/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.fit.metadata.AbstractMetadataElement;
import org.apache.olingo.fit.metadata.Association;
import org.apache.olingo.fit.metadata.Container;
import org.apache.olingo.fit.metadata.EntityType;

public class Schema
extends AbstractMetadataElement {
    private final String namespace;
    private final Map<String, Container> containers;
    private final Map<String, Association> associations;
    private final Map<String, EntityType> entityTypes;

    public Schema(String namespace) {
        this.namespace = namespace;
        this.entityTypes = new HashMap();
        this.containers = new HashMap();
        this.associations = new HashMap();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Collection<EntityType> getEntityTypes() {
        return this.entityTypes.values();
    }

    public EntityType getEntityType(String name) {
        return (EntityType)this.entityTypes.get(name);
    }

    public Schema addEntityType(String name, EntityType entityType) {
        this.entityTypes.put(name, entityType);
        return this;
    }

    public Collection<Container> getContainers() {
        return this.containers.values();
    }

    public Container getContainer(String name) {
        return (Container)this.containers.get(name);
    }

    public Schema addContainer(String name, Container container) {
        this.containers.put(name, container);
        return this;
    }

    public Association getAssociation(String name) {
        return (Association)this.associations.get(name);
    }

    public Schema addAssociation(String name, Association association) {
        this.associations.put(name, association);
        return this;
    }
}

