/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.rest;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class ResolvingReferencesInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ResolvingReferencesInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        String path = (String)message.get((Object)Message.PATH_INFO);
        String query = (String)message.get((Object)Message.QUERY_STRING);
        try {
            if (path.endsWith("$entity") && StringUtils.isNotBlank((CharSequence)query) && URLDecoder.decode(query, "UTF-8").contains("$id=")) {
                String id = URLDecoder.decode(query, "UTF-8");
                String newURL = id.substring(id.indexOf("$id=") + 4);
                URI uri = URI.create(newURL);
                message.put((Object)"org.apache.cxf.request.url", (Object)uri.toASCIIString());
                message.put((Object)"org.apache.cxf.request.uri", (Object)uri.getPath());
                message.put((Object)Message.PATH_INFO, (Object)uri.getPath());
            }
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }
}

