/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.startup.Tomcat;
import org.apache.olingo.fit.server.TomcatTestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class TomcatTestServer {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatTestServer.class);
    private final Tomcat tomcat;
    private static TestServerBuilder builder;

    private TomcatTestServer(Tomcat tomcat) {
        this.tomcat = tomcat;
        this.enableLogging();
    }

    private void enableLogging() {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");
        try {
            FileHandler fileHandler = new FileHandler(this.tomcat.getHost().getAppBase() + "/catalina.out", true);
            fileHandler.setFormatter(new SimpleFormatter());
            fileHandler.setLevel(Level.ALL);
            logger.addHandler(fileHandler);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to configure embedded tomcat logging.");
        }
    }

    public static void main(String[] params) {
        try {
            LOG.trace("Start tomcat embedded server from main()");
            TestServerBuilder server = TomcatTestServer.init((int)9180).addStaticContent("/stub/StaticService/V30/Static.svc/$metadata", "V30/metadata.xml").addStaticContent("/stub/StaticService/V30/ActionOverloading.svc/$metadata", "V30/actionOverloadingMetadata.xml").addStaticContent("/stub/StaticService/V30/OpenType.svc/$metadata", "V30/openTypeMetadata.xml").addStaticContent("/stub/StaticService/V30/PrimitiveKeys.svc/$metadata", "V30/primitiveKeysMetadata.xml").addStaticContent("/stub/StaticService/V40/OpenType.svc/$metadata", "V40/openTypeMetadata.xml").addStaticContent("/stub/StaticService/V40/Demo.svc/$metadata", "V40/demoMetadata.xml").addStaticContent("/stub/StaticService/V40/Static.svc/$metadata", "V40/metadata.xml");
            boolean keepRunning = false;
            for (String param : params) {
                if (param.equalsIgnoreCase("keeprunning")) {
                    keepRunning = true;
                    continue;
                }
                if (param.equalsIgnoreCase("addwebapp")) {
                    server.addWebApp();
                    continue;
                }
                if (!param.startsWith("port")) continue;
                server.atPort(TomcatTestServer.extractPortParam((String)param));
            }
            if (keepRunning) {
                LOG.info("...and keep server running.");
                server.startAndWait();
            } else {
                LOG.info("...and run as long as the thread is running.");
                server.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Tomcat server from main method.", e);
        }
    }

    public static int extractPortParam(String portParameter) {
        String[] portParam = portParameter.split("=");
        if (portParam.length == 2) {
            try {
                return Integer.parseInt(portParam[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Port parameter (" + portParameter + ") could not be parsed.");
            }
        }
        throw new IllegalArgumentException("Port parameter (" + portParameter + ") could not be parsed.");
    }

    public static TestServerBuilder init(int port) {
        if (builder == null) {
            builder = new TestServerBuilder(port, null);
        }
        return builder;
    }

    public void stop() throws LifecycleException {
        if (this.tomcat.getServer() != null && this.tomcat.getServer().getState() != LifecycleState.DESTROYED) {
            if (this.tomcat.getServer().getState() != LifecycleState.STOPPED) {
                this.tomcat.stop();
            }
            this.tomcat.destroy();
        }
    }

    private static void extract(File jarFile, File destDir) throws IOException {
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> enumEntries = jar.entries();
        while (enumEntries.hasMoreElements()) {
            JarEntry file = enumEntries.nextElement();
            File f = new File(destDir, file.getName());
            if (file.isDirectory()) {
                if (f.exists() || f.mkdir()) continue;
                throw new IOException("Unable to create directory at path '" + f.getAbsolutePath() + "'.");
            }
            InputStream is = jar.getInputStream(file);
            FileOutputStream fos = new FileOutputStream(f);
            while (is.available() > 0) {
                fos.write(is.read());
            }
            fos.close();
            is.close();
        }
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

