/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.UnsupportedMediaTypeException;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Accept {
    TEXT(ContentType.TEXT_PLAIN.getMimeType(), ".txt"),
    XML(ContentType.APPLICATION_XML.getMimeType(), ".xml"),
    ATOM(ContentType.APPLICATION_ATOM_XML.getMimeType(), ".xml"),
    JSON(ContentType.APPLICATION_JSON.getMimeType() + ";odata=minimalmetadata", ContentType.APPLICATION_JSON.getMimeType() + ";odata.metadata=minimal", ".full.json"),
    JSON_NOMETA(ContentType.APPLICATION_JSON.getMimeType() + ";odata=nometadata", ContentType.APPLICATION_JSON.getMimeType() + ";odata.metadata=none", ".full.json"),
    JSON_FULLMETA(ContentType.APPLICATION_JSON.getMimeType() + ";odata=fullmetadata", ContentType.APPLICATION_JSON.getMimeType() + ";odata.metadata=full", ".full.json");

    private final String contentTypeV3;
    private final String contentTypeV4;
    private final String fileExtension;
    private static Pattern allTypesPattern;

    private Accept(String contentTypeV3, String fileExtension) {
        this.contentTypeV3 = contentTypeV3;
        this.contentTypeV4 = contentTypeV3;
        this.fileExtension = fileExtension;
    }

    private Accept(String contentTypeV3, String contentTypeV4, String fileExtension) {
        this.contentTypeV3 = contentTypeV3;
        this.contentTypeV4 = contentTypeV4;
        this.fileExtension = fileExtension;
    }

    public String toString(ODataServiceVersion version) {
        return version.compareTo((Enum)ODataServiceVersion.V40) >= 0 ? this.contentTypeV4 : this.contentTypeV3;
    }

    public String getExtension() {
        return this.fileExtension;
    }

    public static Accept parse(String contentType, ODataServiceVersion version) {
        Accept def = version.compareTo((Enum)ODataServiceVersion.V30) <= 0 ? ATOM : JSON_NOMETA;
        return Accept.parse((String)contentType, (ODataServiceVersion)version, (Accept)def);
    }

    public static Accept parse(String contentType, ODataServiceVersion version, Accept def) {
        if (StringUtils.isBlank((CharSequence)contentType) || allTypesPattern.matcher(contentType).matches()) {
            return def;
        }
        if (contentType.startsWith(JSON_NOMETA.toString(version))) {
            return JSON_NOMETA;
        }
        if (contentType.startsWith(JSON_FULLMETA.toString(version))) {
            return JSON_FULLMETA;
        }
        if (contentType.startsWith(JSON.toString(version)) || contentType.startsWith(ContentType.APPLICATION_JSON.getMimeType())) {
            return JSON;
        }
        if (contentType.startsWith(XML.toString(version))) {
            return XML;
        }
        if (contentType.startsWith(ATOM.toString(version))) {
            return ATOM;
        }
        if (contentType.startsWith(TEXT.toString(version))) {
            return TEXT;
        }
        throw new UnsupportedMediaTypeException(contentType);
    }

    static {
        allTypesPattern = Pattern.compile("(.*,)?\\*/\\*([,;].*)?");
    }
}

