/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.EnumMap;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.ResWrap;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.serialization.ODataSerializerException;
import org.apache.olingo.commons.core.serialization.AtomSerializer;
import org.apache.olingo.commons.core.serialization.JsonSerializer;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSManager {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractUtilities.class);
    private static String MEM_PREFIX = "ram://";
    private static String RES_PREFIX = "res://";
    private final FileSystemManager fsManager;
    private static Map<ODataServiceVersion, FSManager> instance = new EnumMap(ODataServiceVersion.class);
    private final ODataServiceVersion version;

    public static FSManager instance(ODataServiceVersion version) throws IOException {
        if (!instance.containsKey(version)) {
            instance.put(version, new FSManager(version));
        }
        return (FSManager)instance.get(version);
    }

    private FSManager(ODataServiceVersion version) throws IOException {
        this.version = version;
        this.fsManager = VFS.getManager();
        FileObject basePath = this.fsManager.resolveFile(RES_PREFIX + File.separatorChar + version.name());
        String absoluteBaseFolder = basePath.getURL().getPath();
        for (FileObject fo : this.find(basePath, null)) {
            if (fo.getType() != FileType.FILE || fo.getName().getBaseName().contains("Metadata") || fo.getName().getBaseName().contains("metadata")) continue;
            String path = fo.getURL().getPath().replace(absoluteBaseFolder, "//" + version.name());
            this.putInMemory(fo.getContent().getInputStream(), path);
        }
    }

    public String getAbsolutePath(String relativePath, Accept accept) {
        return File.separatorChar + this.version.name() + File.separatorChar + relativePath + (accept == null ? "" : accept.getExtension());
    }

    public final FileObject putInMemory(InputStream is, String path) throws IOException {
        LOG.info("Write in memory {}", (Object)path);
        FileObject memObject = this.fsManager.resolveFile(MEM_PREFIX + path);
        if (memObject.exists()) {
            memObject.delete();
        }
        memObject.createFile();
        OutputStream os = memObject.getContent().getOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)os);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)os);
        return memObject;
    }

    public void putInMemory(ResWrap<Entity> container, String relativePath) throws IOException, ODataSerializerException {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, Constants.ENCODING);
        new AtomSerializer(this.version, true).write((Writer)writer, container);
        writer.flush();
        this.putInMemory((InputStream)new ByteArrayInputStream(content.toByteArray()), this.getAbsolutePath(relativePath, Accept.ATOM));
        content.reset();
        new JsonSerializer(this.version, true).write((Writer)writer, container);
        writer.flush();
        this.putInMemory((InputStream)new ByteArrayInputStream(content.toByteArray()), this.getAbsolutePath(relativePath, Accept.JSON_FULLMETA));
    }

    public InputStream readRes(String relativePath, Accept accept) {
        return this.readFile(relativePath, accept, RES_PREFIX);
    }

    public InputStream readFile(String relativePath, Accept accept) {
        return this.readFile(relativePath, accept, MEM_PREFIX);
    }

    public InputStream readFile(String relativePath) {
        return this.readFile(relativePath, null, MEM_PREFIX);
    }

    private InputStream readFile(String relativePath, Accept accept, String fs) {
        String path = this.getAbsolutePath(relativePath, accept);
        LOG.info("Read {}{}", (Object)fs, (Object)path);
        try {
            FileObject fileObject = this.fsManager.resolveFile(fs + path);
            if (fileObject.exists()) {
                return fileObject.getContent().getInputStream();
            }
            LOG.warn("In-memory path '{}' not found", (Object)path);
            throw new NotFoundException();
        }
        catch (FileSystemException e) {
            throw new NotFoundException();
        }
    }

    public void deleteFile(String relativePath) {
        for (Accept accept : Accept.values()) {
            String path = this.getAbsolutePath(relativePath, accept);
            LOG.info("Delete {}", (Object)path);
            try {
                FileObject fileObject = this.fsManager.resolveFile(MEM_PREFIX + path);
                if (!fileObject.exists()) continue;
                fileObject.delete();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
    }

    public void deleteEntity(String relativePath) {
        String path = this.getAbsolutePath(relativePath, null);
        LOG.info("Delete {}", (Object)path);
        try {
            FileObject fileObject = this.fsManager.resolveFile(MEM_PREFIX + path);
            if (fileObject.exists()) {
                fileObject.delete((FileSelector)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FileObject resolve(String path) throws FileSystemException {
        FileObject res = this.fsManager.resolveFile(MEM_PREFIX + path);
        if (!res.exists()) {
            throw new FileSystemException("Unresolved path " + path);
        }
        return res;
    }

    public final FileObject[] find(FileObject fo, String ext) throws FileSystemException {
        return fo.findFiles((FileSelector)new /* Unavailable Anonymous Inner Class!! */);
    }
}

