/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.InjectableSerializerProvider;
import org.apache.olingo.fit.utils.LinkInfo;
import org.apache.olingo.fit.utils.NavigationLinks;

public class JSONUtilities
extends AbstractUtilities {
    private final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public JSONUtilities(ODataServiceVersion version, Metadata metadata) throws IOException {
        super(version, metadata);
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(Boolean.class, (Object)Boolean.TRUE).addValue(ODataServiceVersion.class, (Object)version));
        this.mapper.setSerializerProvider((DefaultSerializerProvider)new InjectableSerializerProvider(this.mapper.getSerializerProvider(), (SerializationConfig)((SerializationConfig)this.mapper.getSerializationConfig().withAttribute(ODataServiceVersion.class, (Object)version)).withAttribute(Boolean.class, (Object)Boolean.TRUE), this.mapper.getSerializerFactory()));
    }

    protected Accept getDefaultFormat() {
        return Accept.JSON_FULLMETA;
    }

    protected InputStream addLinks(String entitySetName, String entitykey, InputStream is, Set<String> links) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(is);
        IOUtils.closeQuietly((InputStream)is);
        for (String link : links) {
            srcNode.set(link + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX), (JsonNode)new TextNode(Commons.getLinksURI((String)entitySetName, (String)entitykey, (String)link)));
        }
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    protected Set<String> retrieveAllLinkNames(InputStream is) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(is);
        IOUtils.closeQuietly((InputStream)is);
        HashSet<String> links = new HashSet<String>();
        Iterator fieldIter = srcNode.fieldNames();
        while (fieldIter.hasNext()) {
            String field = (String)fieldIter.next();
            if (!field.endsWith(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_BIND_SUFFIX)) && !field.endsWith(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX)) && !field.endsWith(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_MEDIA_SUFFIX)) && !field.endsWith(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_EDITLINK_NAME))) continue;
            if (field.indexOf(64) > 0) {
                links.add(field.substring(0, field.indexOf(64)));
                continue;
            }
            links.add(field);
        }
        return links;
    }

    protected NavigationLinks retrieveNavigationInfo(String entitySetName, InputStream is) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(is);
        IOUtils.closeQuietly((InputStream)is);
        NavigationLinks links = new NavigationLinks();
        Iterator fieldIter = srcNode.fields();
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        while (fieldIter.hasNext()) {
            Map.Entry field = (Map.Entry)fieldIter.next();
            if (((String)field.getKey()).endsWith(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_BIND_SUFFIX))) {
                String title = ((String)field.getKey()).substring(0, ((String)field.getKey()).indexOf(64));
                ArrayList<String> hrefs = new ArrayList<String>();
                if (((JsonNode)field.getValue()).isArray()) {
                    for (JsonNode href : (ArrayNode)field.getValue()) {
                        String uri = href.asText();
                        hrefs.add(uri.substring(uri.lastIndexOf(47) + 1));
                    }
                } else {
                    String uri = ((JsonNode)field.getValue()).asText();
                    hrefs.add(uri.substring(uri.lastIndexOf(47) + 1));
                }
                links.addLinks(title, hrefs);
                continue;
            }
            if (!navigationProperties.containsKey(field.getKey())) continue;
            links.addInlines((String)field.getKey(), IOUtils.toInputStream((String)((JsonNode)field.getValue()).toString(), (Charset)Constants.ENCODING));
        }
        return links;
    }

    protected InputStream normalizeLinks(String entitySetName, String entityKey, InputStream is, NavigationLinks links) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(is);
        if (links != null) {
            for (String linkTitle : links.getLinkNames()) {
                srcNode.remove(linkTitle + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_BIND_SUFFIX));
                srcNode.set(linkTitle + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX), (JsonNode)new TextNode(String.format("%s(%s)/%s", entitySetName, entityKey, linkTitle)));
            }
            for (String linkTitle : links.getInlineNames()) {
                srcNode.remove(linkTitle + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_BIND_SUFFIX));
                srcNode.set(linkTitle + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX), (JsonNode)new TextNode(String.format("%s(%s)/%s", entitySetName, entityKey, linkTitle)));
                srcNode.remove(linkTitle);
                links.removeLink(linkTitle);
            }
        }
        srcNode.set(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_EDITLINK_NAME), (JsonNode)new TextNode(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + entitySetName + "(" + entityKey + ")"));
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream addJsonInlinecount(InputStream src, int count) throws Exception {
        JsonNode srcNode = this.mapper.readTree(src);
        ((ObjectNode)srcNode).put(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ODATA_COUNT_NAME), count);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)bos, (Object)srcNode);
        ByteArrayInputStream res = new ByteArrayInputStream(bos.toByteArray());
        IOUtils.closeQuietly((OutputStream)bos);
        return res;
    }

    public InputStream wrapJsonEntities(InputStream entities) throws IOException {
        ObjectNode res;
        JsonNode node = this.mapper.readTree(entities);
        JsonNode value = node.get(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_VALUE_NAME));
        if (value.isArray()) {
            res = this.mapper.createObjectNode();
            res.set("value", value);
            JsonNode next = node.get(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME));
            if (next != null) {
                res.set(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME), next);
            }
        } else {
            res = (ObjectNode)value;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)bos, (Object)res);
        ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
        IOUtils.closeQuietly((OutputStream)bos);
        return is;
    }

    public InputStream selectEntity(InputStream src, String[] propertyNames) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(src);
        HashSet<String> retain = new HashSet<String>();
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_ID_NAME));
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_TYPE_NAME));
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_EDITLINK_NAME));
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME));
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_ODATAMETADATA_NAME));
        retain.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_VALUE_NAME));
        for (String name : propertyNames) {
            retain.add(name);
            retain.add(name + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX));
            retain.add(name + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_MEDIA_SUFFIX));
            retain.add(name + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_TYPE_SUFFIX));
        }
        srcNode.retain(retain);
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream readEntities(List<String> links, String linkName, String next, boolean forceFeed) throws IOException {
        if (links.isEmpty()) {
            throw new NotFoundException();
        }
        ObjectNode node = this.mapper.createObjectNode();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (forceFeed || links.size() > 1) {
            bos.write("[".getBytes());
        }
        for (String link : links) {
            try {
                Map.Entry uriMap = Commons.parseEntityURI((String)link);
                Map.Entry entity = this.readEntity((String)uriMap.getKey(), (String)uriMap.getValue(), Accept.JSON_FULLMETA);
                if (bos.size() > 1) {
                    bos.write(",".getBytes());
                }
                IOUtils.copy((InputStream)((InputStream)entity.getValue()), (OutputStream)bos);
            }
            catch (Exception e) {
                LOG.warn("Error parsing uri {}", (Object)link, (Object)e);
            }
        }
        if (forceFeed || links.size() > 1) {
            bos.write("]".getBytes());
        }
        node.set(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_VALUE_NAME), this.mapper.readTree((InputStream)new ByteArrayInputStream(bos.toByteArray())));
        if (StringUtils.isNotBlank((CharSequence)next)) {
            node.set(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME), (JsonNode)new TextNode(next));
        }
        return IOUtils.toInputStream((String)node.toString(), (Charset)Constants.ENCODING);
    }

    protected InputStream replaceLink(InputStream toBeChanged, String linkName, InputStream replacement) throws IOException {
        ObjectNode toBeChangedNode = (ObjectNode)this.mapper.readTree(toBeChanged);
        ObjectNode replacementNode = (ObjectNode)this.mapper.readTree(replacement);
        if (toBeChangedNode.get(linkName + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NAVIGATION_SUFFIX)) == null) {
            throw new NotFoundException();
        }
        toBeChangedNode.set(linkName, replacementNode.get(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_VALUE_NAME)));
        JsonNode next = replacementNode.get(linkName + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME));
        if (next != null) {
            toBeChangedNode.set(linkName + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_SUFFIX), next);
        }
        return IOUtils.toInputStream((String)toBeChangedNode.toString(), (Charset)Constants.ENCODING);
    }

    protected Map<String, InputStream> getChanges(InputStream src) throws IOException {
        HashMap<String, InputStream> res = new HashMap<String, InputStream>();
        JsonNode srcObject = this.mapper.readTree(src);
        Iterator fields = srcObject.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            res.put((String)field.getKey(), IOUtils.toInputStream((String)((JsonNode)field.getValue()).toString(), (Charset)Constants.ENCODING));
        }
        return res;
    }

    public Map.Entry<String, List<String>> extractLinkURIs(String entitySetName, String entityId, String linkName) throws Exception {
        LinkInfo links = this.readLinks(entitySetName, entityId, linkName, Accept.JSON_FULLMETA);
        return this.extractLinkURIs(links.getLinks());
    }

    public Map.Entry<String, List<String>> extractLinkURIs(InputStream is) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(is);
        IOUtils.closeQuietly((InputStream)is);
        ArrayList<String> links = new ArrayList<String>();
        JsonNode uris = srcNode.get("value");
        if (uris == null) {
            JsonNode url = srcNode.get("url");
            if (url != null) {
                links.add(url.textValue());
            }
        } else {
            Iterator iter = ((ArrayNode)uris).iterator();
            while (iter.hasNext()) {
                links.add(((JsonNode)iter.next()).get("url").textValue());
            }
        }
        JsonNode next = srcNode.get(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_NEXTLINK_NAME));
        return new AbstractMap.SimpleEntry<String, List<String>>(next == null ? null : next.asText(), links);
    }

    public InputStream addEditLink(InputStream content, String title, String href) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(content);
        IOUtils.closeQuietly((InputStream)content);
        srcNode.set(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.JSON_EDITLINK_NAME), (JsonNode)new TextNode(href));
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream addOperation(InputStream content, String name, String metaAnchor, String href) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(content);
        IOUtils.closeQuietly((InputStream)content);
        ObjectNode action = this.mapper.createObjectNode();
        action.set("title", (JsonNode)new TextNode(name));
        action.set("target", (JsonNode)new TextNode(href));
        srcNode.set(metaAnchor, (JsonNode)action);
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream replaceProperty(InputStream src, InputStream replacement, List<String> path, boolean justValue) throws IOException {
        JsonNode replacementNode;
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(src);
        IOUtils.closeQuietly((InputStream)src);
        if (justValue) {
            replacementNode = new TextNode(IOUtils.toString((InputStream)replacement));
        } else {
            replacementNode = this.mapper.readTree(replacement);
            if (replacementNode.has("value")) {
                replacementNode = replacementNode.get("value");
            }
        }
        IOUtils.closeQuietly((InputStream)replacement);
        ObjectNode node = srcNode;
        for (int i = 0; i < path.size() - 1; ++i) {
            if ((node = node.get(path.get(i))) != null) continue;
            throw new NotFoundException();
        }
        node.set(path.get(path.size() - 1), replacementNode);
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }

    public InputStream deleteProperty(InputStream src, List<String> path) throws IOException {
        ObjectNode srcNode = (ObjectNode)this.mapper.readTree(src);
        IOUtils.closeQuietly((InputStream)src);
        ObjectNode node = srcNode;
        for (int i = 0; i < path.size() - 1; ++i) {
            if ((node = node.get(path.get(i))) != null) continue;
            throw new NotFoundException();
        }
        node.set(path.get(path.size() - 1), null);
        return IOUtils.toInputStream((String)srcNode.toString(), (Charset)Constants.ENCODING);
    }
}

