/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import org.apache.olingo.fit.utils.MetadataLinkInfo;

public class MetadataLinkInfo {
    private Map<String, EntitySet> entitySets = new HashMap();

    public void setSingleton(String entitySetName) {
        ((EntitySet)this.entitySets.get(entitySetName)).setSingleton(true);
    }

    public boolean isSingleton(String entitySetName) {
        return ((EntitySet)this.entitySets.get(entitySetName)).isSingleton();
    }

    public Set<String> getEntitySets() {
        return this.entitySets.keySet();
    }

    public void addEntitySet(String entitySetName) {
        if (!this.entitySets.containsKey(entitySetName)) {
            this.entitySets.put(entitySetName, new EntitySet(entitySetName));
        }
    }

    public void addLink(String entitySetName, String linkName, String targetName, boolean isFeed) {
        EntitySet entitySet;
        if (this.entitySets.containsKey(entitySetName)) {
            entitySet = (EntitySet)this.entitySets.get(entitySetName);
        } else {
            entitySet = new EntitySet(entitySetName);
            this.entitySets.put(entitySetName, entitySet);
        }
        entitySet.add(linkName, targetName, isFeed);
    }

    public Set<String> getNavigationLinkNames(String entitySetName) {
        HashSet<String> res = new HashSet<String>();
        if (!this.entitySets.containsKey(entitySetName)) {
            throw new NotFoundException();
        }
        for (NavigationLink navigationLink : ((EntitySet)this.entitySets.get(entitySetName)).getLinks()) {
            res.add(navigationLink.getName());
        }
        return res;
    }

    public boolean exists(String entitySetName, String linkName) {
        try {
            return this.getNavigationLinkNames(entitySetName).contains(linkName);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isFeed(String entitySetName, String linkName) {
        return this.entitySets.containsKey(entitySetName) && ((EntitySet)this.entitySets.get(entitySetName)).isFeed(linkName);
    }

    public String getTargetName(String entitySetName, String linkName) {
        if (!this.entitySets.containsKey(entitySetName)) {
            throw new NotFoundException();
        }
        String targetName = ((EntitySet)this.entitySets.get(entitySetName)).getLink(linkName).getTargetName();
        return targetName.substring(targetName.lastIndexOf(".") + 1);
    }
}

