/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.fit.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.fit.metadata.Metadata;
import org.apache.olingo.fit.metadata.NavigationProperty;
import org.apache.olingo.fit.utils.AbstractUtilities;
import org.apache.olingo.fit.utils.Accept;
import org.apache.olingo.fit.utils.Commons;
import org.apache.olingo.fit.utils.ConstantKey;
import org.apache.olingo.fit.utils.Constants;
import org.apache.olingo.fit.utils.LinkInfo;
import org.apache.olingo.fit.utils.NavigationLinks;
import org.apache.olingo.fit.utils.XMLElement;
import org.apache.olingo.fit.utils.XMLEventReaderWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class XMLUtilities
extends AbstractUtilities {
    protected static XMLInputFactory ifactory = null;
    protected static XMLOutputFactory ofactory = null;

    public XMLUtilities(ODataServiceVersion version, Metadata metadata) throws IOException {
        super(version, metadata);
    }

    protected Accept getDefaultFormat() {
        return Accept.ATOM;
    }

    protected XMLEventReader getEventReader(InputStream is) throws XMLStreamException {
        if (ifactory == null) {
            ifactory = XMLInputFactory.newInstance();
        }
        return ifactory.createXMLEventReader(new InputStreamReader(is, Constants.DECODER));
    }

    protected static XMLEventWriter getEventWriter(OutputStream os) throws XMLStreamException {
        if (ofactory == null) {
            ofactory = XMLOutputFactory.newInstance();
        }
        return ofactory.createXMLEventWriter(os, "UTF-8");
    }

    private void writeEvent(XMLEvent event, XMLEventWriter writer) {
        if (writer != null) {
            try {
                writer.add(event);
            }
            catch (XMLStreamException e) {
                LOG.error("Error writing event {}", (Object)event, (Object)e);
            }
        }
    }

    private void skipElement(StartElement start, XMLEventReader reader, XMLEventWriter writer, boolean excludeStart) throws Exception {
        if (!excludeStart) {
            this.writeEvent((XMLEvent)start, writer);
        }
        int depth = 1;
        boolean found = false;
        while (reader.hasNext() && !found) {
            XMLEvent event = reader.nextEvent();
            this.writeEvent(event, writer);
            if (event.getEventType() == 1) {
                ++depth;
                continue;
            }
            if (event.getEventType() != 2) continue;
            found = --depth == 0 && start.getName().equals(event.asEndElement().getName());
        }
    }

    protected InputStream addLinks(String entitySetName, String entitykey, InputStream is, Set<String> links) throws Exception {
        XMLEventReader reader = this.getEventReader(is);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        Map.Entry entry = this.extractElement(reader, writer, Collections.singletonList("entry"), 0, 1, 1);
        writer.add(((XMLElement)entry.getValue()).getStart());
        Map navigationProperties = this.metadata.getNavigationProperties(entitySetName);
        for (String link : links) {
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            attributes.add(eventFactory.createAttribute(new QName("title"), link));
            attributes.add(eventFactory.createAttribute(new QName("href"), Commons.getLinksURI((String)entitySetName, (String)entitykey, (String)link)));
            attributes.add(eventFactory.createAttribute(new QName("rel"), Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_REL) + link));
            attributes.add(eventFactory.createAttribute(new QName("type"), ((NavigationProperty)navigationProperties.get(link)).isEntitySet() ? Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_FEED) : Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_LINK_ENTRY)));
            writer.add(eventFactory.createStartElement(new QName(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), attributes.iterator(), null));
            writer.add(eventFactory.createEndElement(new QName(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), null));
        }
        writer.add(((XMLElement)entry.getValue()).getContentReader(this.version));
        writer.add(((XMLElement)entry.getValue()).getEnd());
        writer.add(reader);
        IOUtils.closeQuietly((InputStream)is);
        writer.flush();
        writer.close();
        reader.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> retrieveAllLinkNames(InputStream is) throws Exception {
        HashSet<String> links = new HashSet<String>();
        XMLEventReader reader = this.getEventReader(is);
        try {
            try {
                int startDepth = 0;
                while (true) {
                    Map.Entry linkInfo = this.extractElement(reader, null, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), startDepth, 2, 2);
                    startDepth = (Integer)linkInfo.getKey();
                    links.add(((XMLElement)linkInfo.getValue()).getStart().getAttributeByName(new QName("title")).getValue());
                }
            }
            catch (Exception ignore) {
                reader.close();
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        catch (Throwable throwable) {
            reader.close();
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NavigationLinks retrieveNavigationInfo(String entitySetName, InputStream is) throws Exception {
        NavigationLinks links = new NavigationLinks();
        XMLEventReader reader = this.getEventReader(is);
        try {
            try {
                ArrayList<AbstractMap.SimpleEntry<String, String>> filter = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                filter.add(new AbstractMap.SimpleEntry<String, String>("type", "application/atom+xml;type=entry"));
                filter.add(new AbstractMap.SimpleEntry<String, String>("type", "application/atom+xml;type=feed"));
                int startDepth = 0;
                while (true) {
                    Map.Entry linkInfo = this.extractElement(reader, null, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), filter, true, startDepth, 2, 2);
                    XMLElement link = (XMLElement)linkInfo.getValue();
                    startDepth = (Integer)linkInfo.getKey();
                    String title = link.getStart().getAttributeByName(new QName("title")).getValue();
                    Attribute hrefAttr = link.getStart().getAttributeByName(new QName("href"));
                    String href = hrefAttr == null ? null : hrefAttr.getValue();
                    try {
                        XMLElement inlineElement = (XMLElement)this.extractElement(link.getContentReader(this.version), null, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.INLINE)), 0, -1, -1).getValue();
                        XMLEventReader inlineReader = inlineElement.getContentReader(this.version);
                        try {
                            while (true) {
                                XMLElement entry = (XMLElement)this.extractElement(inlineReader, null, Collections.singletonList("entry"), 0, -1, -1).getValue();
                                links.addInlines(title, entry.toStream());
                            }
                        }
                        catch (Exception e) {
                            inlineReader.close();
                        }
                    }
                    catch (Exception ignore) {
                        if (!StringUtils.isNotBlank((CharSequence)href) || !ENTITY_URI_PATTERN.matcher(href).matches()) continue;
                        links.addLinks(title, href.substring(href.lastIndexOf(47) + 1));
                    }
                }
            }
            catch (Exception ignore) {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            reader.close();
            throw throwable;
        }
        return links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream normalizeLinks(String entitySetName, String entityKey, InputStream is, NavigationLinks links) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        is.close();
        ByteArrayOutputStream tmpBos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)tmpBos);
        XMLEventReader reader = this.getEventReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        HashSet<String> added = new HashSet<String>();
        try {
            try {
                ArrayList<AbstractMap.SimpleEntry<String, String>> filter = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
                filter.add(new AbstractMap.SimpleEntry<String, String>("type", "application/atom+xml;type=entry"));
                filter.add(new AbstractMap.SimpleEntry<String, String>("type", "application/atom+xml;type=feed"));
                Map.Entry linkInfo = null;
                while (true) {
                    XMLElement link;
                    String title;
                    if (added.contains(title = (link = (XMLElement)(linkInfo = this.extractElement(reader, writer, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), filter, true, linkInfo == null ? 0 : (Integer)linkInfo.getKey(), 2, 2)).getValue()).getStart().getAttributeByName(new QName("title")).getValue())) {
                        continue;
                    }
                    added.add(title);
                    String normalizedLink = String.format("<link href=\"%s(%s)/%s\" rel=\"%s\" title=\"%s\" type=\"%s\"/>", entitySetName, entityKey, title, link.getStart().getAttributeByName(new QName("rel")).getValue(), title, link.getStart().getAttributeByName(new QName("type")).getValue());
                    this.addAtomElement(IOUtils.toInputStream((String)normalizedLink, (Charset)Constants.ENCODING), writer);
                }
            }
            catch (Exception ignore) {
                writer.close();
                reader.close();
            }
        }
        catch (Throwable throwable) {
            writer.close();
            reader.close();
            throw throwable;
        }
        InputStream content = this.addEditLink((InputStream)new ByteArrayInputStream(tmpBos.toByteArray()), entitySetName, Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + entitySetName + "(" + entityKey + ")");
        return this.addAtomContent(content, entitySetName, Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + entitySetName + "(" + entityKey + ")");
    }

    public XMLElement getXmlElement(StartElement start, XMLEventReader reader) throws Exception {
        XMLElement res = new XMLElement();
        res.setStart(start);
        Charset encoding = Charset.forName("UTF-8");
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, encoding);
        int depth = 1;
        while (reader.hasNext() && depth > 0) {
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() == 1) {
                ++depth;
            } else if (event.getEventType() == 2) {
                --depth;
            }
            if (depth == 0) {
                res.setEnd(event.asEndElement());
                continue;
            }
            event.writeAsEncodedUnicode(writer);
        }
        writer.flush();
        writer.close();
        res.setContent((InputStream)new ByteArrayInputStream(content.toByteArray()));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAtomElement(InputStream content, XMLEventWriter writer) throws Exception {
        XMLEventReader reader = this.getEventReader(content);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        Characters newLine = eventFactory.createSpace("\n");
        try {
            writer.add(newLine);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.getEventType() == 7 || event.getEventType() == 8 || event.getEventType() == 5) continue;
                writer.add(event);
            }
            writer.add(newLine);
        }
        finally {
            reader.close();
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream addEditLink(InputStream content, String title, String href) throws Exception {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)content, (OutputStream)copy);
        IOUtils.closeQuietly((InputStream)content);
        XMLEventReader reader = this.getEventReader((InputStream)new ByteArrayInputStream(copy.toByteArray()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        String editLinkElement = String.format("<link rel=\"edit\" title=\"%s\" href=\"%s\" />", title, href);
        try {
            this.extractElement(reader, writer, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), Collections.singletonList(new AbstractMap.SimpleEntry<String, String>("rel", "edit")), false, 0, -1, -1);
            this.addAtomElement(IOUtils.toInputStream((String)editLinkElement, (Charset)Constants.ENCODING), writer);
            writer.add(reader);
        }
        catch (Exception e) {
            reader.close();
            reader = this.getEventReader((InputStream)new ByteArrayInputStream(copy.toByteArray()));
            bos = new ByteArrayOutputStream();
            writer = XMLUtilities.getEventWriter((OutputStream)bos);
            XMLElement entryElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList("entry"), 0, 1, 1).getValue();
            writer.add(entryElement.getStart());
            this.addAtomElement(IOUtils.toInputStream((String)editLinkElement, (Charset)Constants.ENCODING), writer);
            writer.add(entryElement.getContentReader(this.version));
            writer.add(entryElement.getEnd());
            writer.add(reader);
            writer.flush();
            writer.close();
        }
        finally {
            reader.close();
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public InputStream addOperation(InputStream content, String name, String metaAnchor, String href) throws Exception {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)content, (OutputStream)copy);
        IOUtils.closeQuietly((InputStream)content);
        String action = String.format("<m:action metadata=\"%s%s\" title=\"%s\" target=\"%s\"/>", Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL), metaAnchor, name, href);
        String newContent = new String(copy.toByteArray(), "UTF-8").replaceAll("\\<content ", action + "\\<content ");
        return IOUtils.toInputStream((String)newContent, (String)"UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream addAtomContent(InputStream content, String title, String href) throws Exception {
        ByteArrayOutputStream copy = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)content, (OutputStream)copy);
        IOUtils.closeQuietly((InputStream)content);
        XMLEventReader reader = this.getEventReader((InputStream)new ByteArrayInputStream(copy.toByteArray()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        try {
            XMLElement contentElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList("content"), 0, 2, 2).getValue();
            writer.add(contentElement.getStart());
            writer.add(contentElement.getContentReader(this.version));
            writer.add(contentElement.getEnd());
            writer.add(reader);
        }
        catch (Exception e) {
            reader.close();
            reader = this.getEventReader((InputStream)new ByteArrayInputStream(copy.toByteArray()));
            bos = new ByteArrayOutputStream();
            writer = XMLUtilities.getEventWriter((OutputStream)bos);
            if (this.isMediaContent(title)) {
                XMLElement entryElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList("entry"), 0, 1, 1).getValue();
                writer.add(entryElement.getStart());
                writer.add(entryElement.getContentReader(this.version));
                this.addAtomElement(IOUtils.toInputStream((String)String.format("<content type=\"*/*\" src=\"%s/$value\" />", href)), writer);
                writer.add(entryElement.getEnd());
            } else {
                try {
                    XMLElement entryElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.PROPERTIES)), 0, 2, 3).getValue();
                    this.addAtomElement(IOUtils.toInputStream((String)"<content type=\"application/xml\">"), writer);
                    writer.add(entryElement.getStart());
                    writer.add(entryElement.getContentReader(this.version));
                    writer.add(entryElement.getEnd());
                    this.addAtomElement(IOUtils.toInputStream((String)"</content>"), writer);
                }
                catch (Exception nf) {
                    reader.close();
                    reader = this.getEventReader((InputStream)new ByteArrayInputStream(copy.toByteArray()));
                    bos = new ByteArrayOutputStream();
                    writer = XMLUtilities.getEventWriter((OutputStream)bos);
                    XMLElement entryElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList("entry"), 0, 1, 1).getValue();
                    writer.add(entryElement.getStart());
                    writer.add(entryElement.getContentReader(this.version));
                    this.addAtomElement(IOUtils.toInputStream((String)"<content type=\"application/xml\"/>"), writer);
                    writer.add(entryElement.getEnd());
                }
            }
            writer.add(reader);
            writer.flush();
            writer.close();
        }
        finally {
            reader.close();
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public int countAllElements(String entitySetName) throws Exception {
        String basePath = entitySetName + File.separatorChar;
        int count = this.countFeedElements(this.fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.FEED), Accept.XML), "entry");
        String skipTokenDirPath = this.fsManager.getAbsolutePath(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.SKIP_TOKEN), null);
        try {
            FileObject[] files;
            FileObject skipToken = this.fsManager.resolve(skipTokenDirPath);
            for (FileObject file : files = this.fsManager.find(skipToken, Accept.XML.getExtension().substring(1))) {
                count += this.countFeedElements(this.fsManager.readFile(basePath + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.SKIP_TOKEN) + File.separatorChar + file.getName().getBaseName(), null), "entry");
            }
        }
        catch (FileSystemException fse) {
            LOG.debug("Resource path '{}' not found", (Object)skipTokenDirPath);
        }
        return count;
    }

    private int countFeedElements(InputStream is, String elementName) throws XMLStreamException {
        XMLEventReader reader = this.getEventReader(is);
        int count = 0;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() != 1 || !elementName.equals(event.asStartElement().getName().getLocalPart())) continue;
            ++count;
        }
        reader.close();
        return count;
    }

    public Map.Entry<Integer, XMLElement> extractElement(XMLEventReader reader, XMLEventWriter writer, List<String> path, int startPathPos, int minPathPos, int maxPathPos) throws Exception {
        return this.extractElement(reader, writer, path, null, false, startPathPos, minPathPos, maxPathPos);
    }

    public Map.Entry<Integer, XMLElement> extractElement(XMLEventReader reader, XMLEventWriter writer, List<String> path, Collection<Map.Entry<String, String>> filter, boolean filterInOr, int startPathPos, int minPathPos, int maxPathPos) throws Exception {
        Collection<Object> filterAttrs;
        StartElement start = null;
        int searchFor = 0;
        int depth = startPathPos;
        String current = null;
        List<Object> pathElementNames = path == null ? Collections.emptyList() : path;
        Collection<Object> collection = filterAttrs = filter == null ? Collections.emptySet() : filter;
        while (reader.hasNext() && start == null) {
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() == 1) {
                if (current != null || (minPathPos < 0 || minPathPos <= ++depth) && (maxPathPos < 0 || depth <= maxPathPos)) {
                    if (pathElementNames.isEmpty() || ((String)pathElementNames.get(searchFor)).trim().equals(event.asStartElement().getName().getLocalPart())) {
                        if (searchFor < pathElementNames.size() - 1) {
                            this.writeEvent(event, writer);
                            current = ((String)pathElementNames.get(searchFor)).trim();
                            ++searchFor;
                            continue;
                        }
                        boolean match = filterAttrs.isEmpty() || !filterInOr;
                        for (Map.Entry entry : filterAttrs) {
                            Attribute attr = event.asStartElement().getAttributeByName(new QName(((String)entry.getKey()).trim()));
                            if (attr == null || !((String)entry.getValue()).trim().equals(attr.getValue())) {
                                match = filterInOr ? match : false;
                                continue;
                            }
                            match = filterInOr ? true : match;
                        }
                        if (match) {
                            start = event.asStartElement();
                            continue;
                        }
                        this.skipElement(event.asStartElement(), reader, writer, false);
                        --depth;
                        continue;
                    }
                    if (current == null) {
                        this.writeEvent(event, writer);
                        continue;
                    }
                    this.skipElement(event.asStartElement(), reader, writer, false);
                    --depth;
                    continue;
                }
                this.writeEvent(event, writer);
                continue;
            }
            if (event.getEventType() == 2) {
                --depth;
                this.writeEvent(event, writer);
                if (!event.asEndElement().getName().getLocalPart().equals(current)) continue;
                current = --searchFor > 0 ? ((String)pathElementNames.get(searchFor - 1)).trim() : null;
                continue;
            }
            this.writeEvent(event, writer);
        }
        if (start == null) {
            throw new NotFoundException();
        }
        return new AbstractMap.SimpleEntry<Integer, XMLElement>(depth - 1, this.getXmlElement(start, reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream addAtomInlinecount(InputStream feed, int count) throws Exception {
        XMLEventReader reader = this.getEventReader(feed);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        try {
            XMLElement feedElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList("feed"), 0, 1, 1).getValue();
            writer.add(feedElement.getStart());
            this.addAtomElement(IOUtils.toInputStream((String)String.format("<m:count>%d</m:count>", count), (Charset)Constants.ENCODING), writer);
            writer.add(feedElement.getContentReader(this.version));
            writer.add(feedElement.getEnd());
            while (reader.hasNext()) {
                writer.add(reader.nextEvent());
            }
        }
        finally {
            writer.flush();
            writer.close();
            reader.close();
            IOUtils.closeQuietly((InputStream)feed);
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public InputStream selectEntity(InputStream entity, String[] propertyNames) throws Exception {
        XMLEventReader reader = this.getEventReader(entity);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        ArrayList<String> found = new ArrayList<String>(Arrays.asList(propertyNames));
        boolean inProperties = false;
        boolean writeCurrent = true;
        Boolean writeNext = null;
        String currentName = null;
        ArrayList<String> fieldToBeSaved = new ArrayList<String>(Arrays.asList(propertyNames));
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.getEventType() == 1 && Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK).equals(event.asStartElement().getName().getLocalPart()) && !fieldToBeSaved.contains(event.asStartElement().getAttributeByName(new QName("title")).getValue()) && !"edit".equals(event.asStartElement().getAttributeByName(new QName("rel")).getValue())) {
                writeCurrent = false;
            } else if (event.getEventType() == 2 && Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK).equals(event.asEndElement().getName().getLocalPart())) {
                writeNext = true;
            } else if (event.getEventType() == 1 && Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.PROPERTIES).equals(event.asStartElement().getName().getLocalPart())) {
                writeCurrent = true;
                writeNext = false;
                inProperties = true;
            } else if (event.getEventType() == 2 && Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.PROPERTIES).equals(event.asEndElement().getName().getLocalPart())) {
                writeCurrent = true;
            } else if (inProperties) {
                if (event.getEventType() == 1) {
                    String elementName = event.asStartElement().getName().getLocalPart();
                    for (String propertyName : propertyNames) {
                        if (!(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_PROPERTY_PREFIX) + propertyName.trim()).equals(elementName)) continue;
                        writeCurrent = true;
                        found.remove(propertyName);
                        currentName = propertyName;
                    }
                } else if (event.getEventType() == 2 && StringUtils.isNotBlank(currentName) && (Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_PROPERTY_PREFIX) + currentName.trim()).equals(event.asEndElement().getName().getLocalPart())) {
                    writeNext = false;
                    currentName = null;
                }
            }
            if (writeCurrent) {
                writer.add(event);
            }
            if (writeNext == null) continue;
            writeCurrent = writeNext;
            writeNext = null;
        }
        writer.flush();
        writer.close();
        reader.close();
        IOUtils.closeQuietly((InputStream)entity);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public InputStream readEntities(List<String> links, String linkName, String next, boolean forceFeed) throws Exception {
        if (links.isEmpty()) {
            throw new NotFoundException();
        }
        Charset encoding = Charset.forName("UTF-8");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, encoding);
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>".toCharArray());
        if (forceFeed || links.size() > 1) {
            writer.write(("<feed xml:base=\"" + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + "\" " + "xmlns=\"http://www.w3.org/2005/Atom\" " + "xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" " + "xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\">").toCharArray());
            writer.write(("<id>" + Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.DEFAULT_SERVICE_URL) + "entityset(entityid)/" + linkName + "</id>").toCharArray());
            writer.write(("<title type=\"text\">" + linkName + "</title>").toCharArray());
            writer.write("<updated>2014-03-03T13:40:49Z</updated>".toCharArray());
            writer.write(("<link rel=\"self\" title=\"" + linkName + "\" href=\"" + linkName + "\" />").toCharArray());
        }
        for (String link : links) {
            try {
                Map.Entry uri = Commons.parseEntityURI((String)link);
                XMLElement entry = (XMLElement)this.extractElement(this.getEventReader((InputStream)this.readEntity((String)uri.getKey(), (String)uri.getValue(), Accept.ATOM).getValue()), null, Collections.singletonList("entry"), 0, 1, 1).getValue();
                IOUtils.copy((InputStream)entry.toStream(), (Writer)writer, (Charset)encoding);
            }
            catch (Exception e) {
                LOG.warn("Error parsing uri {}", (Object)link, (Object)e);
            }
        }
        if (forceFeed || links.size() > 1) {
            if (StringUtils.isNotBlank((CharSequence)next)) {
                writer.write(String.format("<link rel=\"next\" href=\"%s\" />", next).toCharArray());
            }
            writer.write("</feed>".toCharArray());
        }
        writer.flush();
        writer.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public Map<String, InputStream> getChanges(InputStream src) throws Exception {
        HashMap<String, InputStream> res = new HashMap<String, InputStream>();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)src, (OutputStream)bos);
        IOUtils.closeQuietly((InputStream)src);
        XMLEventReader reader = this.getEventReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        Map.Entry propertyElement = this.extractElement(reader, null, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.PROPERTIES)), 0, 2, 3);
        reader.close();
        reader = ((XMLElement)propertyElement.getValue()).getContentReader(this.version);
        try {
            while (true) {
                XMLElement property = (XMLElement)this.extractElement(reader, null, null, 0, -1, -1).getValue();
                res.put(property.getStart().getName().getLocalPart(), property.toStream());
            }
        }
        catch (Exception ignore) {
            reader.close();
            reader = this.getEventReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
            try {
                int pos = 0;
                while (true) {
                    Map.Entry linkElement = this.extractElement(reader, null, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), pos, 2, 2);
                    res.put("[Constants.get(version, ConstantKey.LINK)]" + ((XMLElement)linkElement.getValue()).getStart().getAttributeByName(new QName("title")).getValue(), ((XMLElement)linkElement.getValue()).toStream());
                    pos = (Integer)linkElement.getKey();
                }
            }
            catch (Exception ignore2) {
                return res;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream replaceLink(InputStream toBeChanged, String linkName, InputStream replacement) throws Exception {
        XMLEventReader reader = this.getEventReader(toBeChanged);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        Characters newLine = eventFactory.createSpace("\n");
        try {
            XMLElement linkElement = (XMLElement)this.extractElement(reader, writer, Collections.singletonList(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.LINK)), Collections.singletonList(new AbstractMap.SimpleEntry<String, String>("title", linkName)), false, 0, -1, -1).getValue();
            writer.add(linkElement.getStart());
            writer.add(newLine);
            writer.add(eventFactory.createStartElement("m", null, "inline"));
            this.addAtomElement(replacement, writer);
            writer.add(eventFactory.createEndElement("m", null, "inline"));
            writer.add(newLine);
            writer.add(linkElement.getEnd());
            writer.add(reader);
            writer.flush();
            writer.close();
        }
        finally {
            reader.close();
            IOUtils.closeQuietly((InputStream)toBeChanged);
        }
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public Map.Entry<String, List<String>> extractLinkURIs(String entitySetName, String entityId, String linkName) throws Exception {
        LinkInfo links = this.readLinks(entitySetName, entityId, linkName, Accept.XML);
        return this.extractLinkURIs(links.getLinks());
    }

    public Map.Entry<String, List<String>> extractLinkURIs(InputStream is) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)bos);
        IOUtils.closeQuietly((InputStream)is);
        XMLEventReader reader = this.getEventReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        ArrayList<String> links = new ArrayList<String>();
        try {
            while (true) {
                links.add(IOUtils.toString((InputStream)((XMLElement)this.extractElement(reader, null, Collections.singletonList("uri"), 0, -1, -1).getValue()).getContent()));
            }
        }
        catch (Exception ignore) {
            String next;
            reader.close();
            reader = this.getEventReader((InputStream)new ByteArrayInputStream(bos.toByteArray()));
            try {
                next = IOUtils.toString((InputStream)((XMLElement)this.extractElement(reader, null, Collections.singletonList("next"), 0, -1, -1).getValue()).getContent());
            }
            catch (Exception ignore2) {
                next = null;
            }
            reader.close();
            return new AbstractMap.SimpleEntry(next, links);
        }
    }

    public InputStream replaceProperty(InputStream src, InputStream replacement, List<String> path, boolean justValue) throws Exception {
        ArrayList<String> pathElements = new ArrayList<String>();
        for (String element : path) {
            pathElements.add(Constants.get((ODataServiceVersion)this.version, (ConstantKey)ConstantKey.ATOM_PROPERTY_PREFIX) + element);
        }
        XMLEventReader reader = this.getEventReader(src);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        Map.Entry element = this.extractElement(reader, writer, pathElements, 0, 3, 4);
        if (justValue) {
            writer.add(((XMLElement)element.getValue()).getStart());
        }
        XMLEventReaderWrapper changesReader = new XMLEventReaderWrapper(replacement, this.version);
        while (changesReader.hasNext()) {
            XMLEvent event = changesReader.nextEvent();
            if (event.isStartElement() && event.asStartElement().getName().equals(((XMLElement)element.getValue()).getStart().getName())) {
                writer.add(((XMLElement)element.getValue()).getStart());
                writer.add((XMLEventReader)changesReader);
                continue;
            }
            writer.add(event);
        }
        changesReader.close();
        IOUtils.closeQuietly((InputStream)replacement);
        if (justValue) {
            writer.add(((XMLElement)element.getValue()).getEnd());
        }
        writer.add(reader);
        reader.close();
        IOUtils.closeQuietly((InputStream)src);
        writer.flush();
        writer.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    public InputStream deleteProperty(InputStream src, List<String> path) throws Exception {
        XMLEventReader reader = this.getEventReader(src);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEventWriter writer = XMLUtilities.getEventWriter((OutputStream)bos);
        XMLEventReaderWrapper changesReader = new XMLEventReaderWrapper(IOUtils.toInputStream((String)String.format("<%s m:null=\"true\" />", path.get(path.size() - 1)), (Charset)Constants.ENCODING), this.version);
        writer.add((XMLEventReader)changesReader);
        changesReader.close();
        writer.add(reader);
        reader.close();
        IOUtils.closeQuietly((InputStream)src);
        writer.flush();
        writer.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }
}

