/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.util.Locale;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerException;

public class ODataExceptionHandler {
    public Locale requestedLocale;
    public ODataFormat requestedFormat = ODataFormat.JSON;

    public void handle(ODataResponse resp, Exception e) {
        if (resp.getStatusCode() == 0) {
            resp.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        ODataServerError error = new ODataServerError();
        if (e instanceof ODataTranslatedException) {
            error.setMessage(((ODataTranslatedException)((Object)e)).getTranslatedMessage(this.requestedLocale).getMessage());
        } else {
            error.setMessage(e.getMessage());
        }
        try {
            ODataSerializer serializer = OData.newInstance().createSerializer(this.requestedFormat);
            resp.setContent(serializer.error(error));
        }
        catch (ODataSerializerException e1) {
            // empty catch block
        }
    }
}

