/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.ODataRuntimeException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.serializer.ODataSerializerException;
import org.apache.olingo.server.core.ODataExceptionHandler;
import org.apache.olingo.server.core.ODataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ODataHttpHandlerImpl
implements ODataHttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ODataHttpHandlerImpl.class);
    private ODataHandler handler;
    private int split = 0;

    public ODataHttpHandlerImpl(OData odata, Edm edm) {
        this.handler = new ODataHandler(odata, edm);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) {
        ODataRequest odRequest = null;
        ODataResponse odResponse = null;
        try {
            odRequest = this.createODataRequest(request, this.split);
            odResponse = this.handler.process(odRequest);
        }
        catch (Exception e) {
            odResponse = this.handleException(e);
        }
        ODataHttpHandlerImpl.convertToHttp((HttpServletResponse)response, (ODataResponse)odResponse);
    }

    public void setSplit(int split) {
        this.split = split;
    }

    private ODataResponse handleException(Exception e) {
        ODataResponse resp = new ODataResponse();
        if (e instanceof ODataTranslatedException) {
            ODataTranslatedException exp = (ODataTranslatedException)((Object)e);
            if (exp.getMessageKey() == ODataTranslatedException.MessageKeys.AMBIGUOUS_XHTTP_METHOD) {
                resp.setStatusCode(HttpStatusCode.BAD_REQUEST.getStatusCode());
            } else if (exp.getMessageKey() == ODataTranslatedException.MessageKeys.HTTP_METHOD_NOT_IMPLEMENTED) {
                resp.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
            }
        }
        ODataExceptionHandler exceptionHandler = new ODataExceptionHandler();
        exceptionHandler.handle(resp, e);
        return resp;
    }

    static void convertToHttp(HttpServletResponse response, ODataResponse odResponse) {
        response.setStatus(odResponse.getStatusCode());
        for (Map.Entry entry : odResponse.getHeaders().entrySet()) {
            response.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        InputStream input = odResponse.getContent();
        if (input != null) {
            try {
                ServletOutputStream output = response.getOutputStream();
                byte[] buffer = new byte[1024];
                int n = 0;
                while (-1 != (n = input.read(buffer))) {
                    output.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new ODataRuntimeException((Exception)e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        throw new ODataRuntimeException((Exception)e);
                    }
                }
            }
        }
    }

    private ODataRequest createODataRequest(HttpServletRequest httpRequest, int split) throws ODataTranslatedException {
        try {
            ODataRequest odRequest = new ODataRequest();
            odRequest.setBody((InputStream)httpRequest.getInputStream());
            ODataHttpHandlerImpl.extractHeaders((ODataRequest)odRequest, (HttpServletRequest)httpRequest);
            ODataHttpHandlerImpl.extractMethod((ODataRequest)odRequest, (HttpServletRequest)httpRequest);
            ODataHttpHandlerImpl.extractUri((ODataRequest)odRequest, (HttpServletRequest)httpRequest, (int)split);
            return odRequest;
        }
        catch (IOException e) {
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
    }

    static void extractMethod(ODataRequest odRequest, HttpServletRequest httpRequest) throws ODataTranslatedException {
        try {
            HttpMethod httpRequestMethod = HttpMethod.valueOf((String)httpRequest.getMethod());
            if (httpRequestMethod == HttpMethod.POST) {
                String xHttpMethod = httpRequest.getHeader("X-HTTP-Method");
                String xHttpMethodOverride = httpRequest.getHeader("X-HTTP-Method-Override");
                if (xHttpMethod == null && xHttpMethodOverride == null) {
                    odRequest.setMethod(httpRequestMethod);
                } else if (xHttpMethod == null && xHttpMethodOverride != null) {
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethodOverride));
                } else if (xHttpMethod != null && xHttpMethodOverride == null) {
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethod));
                } else {
                    if (!xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                        throw new ODataTranslatedException("Ambiguous X-HTTP-Methods", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.AMBIGUOUS_XHTTP_METHOD, new String[]{xHttpMethod, xHttpMethodOverride});
                    }
                    odRequest.setMethod(HttpMethod.valueOf((String)xHttpMethod));
                }
            } else {
                odRequest.setMethod(httpRequestMethod);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ODataTranslatedException("Invalid http method" + httpRequest.getMethod(), (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.HTTP_METHOD_NOT_IMPLEMENTED, new String[]{httpRequest.getMethod()});
        }
    }

    static void extractUri(ODataRequest odRequest, HttpServletRequest httpRequest, int split) {
        String rawServiceResolutionUri;
        String rawODataPath;
        int beginIndex;
        String rawRequestUri = httpRequest.getRequestURL().toString();
        if (!"".equals(httpRequest.getServletPath())) {
            beginIndex = rawRequestUri.indexOf(httpRequest.getServletPath());
            rawODataPath = rawRequestUri.substring(beginIndex += httpRequest.getServletPath().length());
        } else if (!"".equals(httpRequest.getContextPath())) {
            beginIndex = rawRequestUri.indexOf(httpRequest.getContextPath());
            rawODataPath = rawRequestUri.substring(beginIndex += httpRequest.getContextPath().length());
        } else {
            rawODataPath = httpRequest.getRequestURI();
        }
        if (split > 0) {
            rawServiceResolutionUri = rawODataPath;
            for (int i = 0; i < split; ++i) {
                int e = rawODataPath.indexOf("/", 1);
                rawODataPath = -1 == e ? "" : rawODataPath.substring(e);
            }
            int end = rawServiceResolutionUri.length() - rawODataPath.length();
            rawServiceResolutionUri = rawServiceResolutionUri.substring(0, end);
        } else {
            rawServiceResolutionUri = null;
        }
        String rawBaseUri = rawRequestUri.substring(0, rawRequestUri.length() - rawODataPath.length());
        odRequest.setRawQueryPath(httpRequest.getQueryString());
        odRequest.setRawRequestUri(rawRequestUri + (httpRequest.getQueryString() == null ? "" : "?" + httpRequest.getQueryString()));
        odRequest.setRawODataPath(rawODataPath);
        odRequest.setRawBaseUri(rawBaseUri);
        odRequest.setRawServiceResolutionUri(rawServiceResolutionUri);
    }

    static void extractHeaders(ODataRequest odRequest, HttpServletRequest req) {
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> headerValues = new ArrayList<String>();
            Enumeration headers = req.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String value = (String)headers.nextElement();
                headerValues.add(value);
            }
            odRequest.addHeader(headerName, headerValues);
        }
    }

    public void register(Processor processor) {
        this.handler.register(processor);
    }
}

