/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.Target;
import org.apache.olingo.commons.core.edm.AbstractEdmBindingTarget;
import org.apache.olingo.commons.core.edm.EdmNavigationPropertyBindingImpl;
import org.apache.olingo.server.api.edm.provider.BindingTarget;
import org.apache.olingo.server.api.edm.provider.NavigationPropertyBinding;

public abstract class EdmBindingTargetImpl
extends AbstractEdmBindingTarget {
    private final BindingTarget target;
    private List<EdmNavigationPropertyBinding> navigationPropertyBindings;

    public EdmBindingTargetImpl(Edm edm, EdmEntityContainer container, BindingTarget target) {
        super(edm, container, target.getName(), target.getType());
        this.target = target;
    }

    public List<EdmNavigationPropertyBinding> getNavigationPropertyBindings() {
        if (this.navigationPropertyBindings == null) {
            List providerBindings = this.target.getNavigationPropertyBindings();
            this.navigationPropertyBindings = new ArrayList();
            if (providerBindings != null) {
                for (NavigationPropertyBinding binding : providerBindings) {
                    Target providerTarget = binding.getTarget();
                    String targetString = "";
                    if (providerTarget.getEntityContainer() != null) {
                        targetString = targetString + providerTarget.getEntityContainer().getFullQualifiedNameAsString() + "/";
                    }
                    targetString = targetString + providerTarget.getTargetName();
                    this.navigationPropertyBindings.add(new EdmNavigationPropertyBindingImpl(binding.getPath(), targetString));
                }
            }
        }
        return this.navigationPropertyBindings;
    }
}

