/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmReferentialConstraint;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdmNavigationProperty;
import org.apache.olingo.server.api.edm.provider.NavigationProperty;
import org.apache.olingo.server.api.edm.provider.ReferentialConstraint;
import org.apache.olingo.server.core.edm.provider.EdmReferentialConstraintImpl;

public class EdmNavigationPropertyImpl
extends AbstractEdmNavigationProperty {
    private final FullQualifiedName structuredTypeName;
    private final NavigationProperty navigationProperty;
    private List<EdmReferentialConstraint> referentialConstraints;

    public EdmNavigationPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, NavigationProperty navigationProperty) {
        super(edm, navigationProperty.getName());
        this.structuredTypeName = structuredTypeName;
        this.navigationProperty = navigationProperty;
    }

    protected FullQualifiedName getTypeFQN() {
        return this.navigationProperty.getType();
    }

    public boolean isCollection() {
        return this.navigationProperty.isCollection();
    }

    public Boolean isNullable() {
        return this.navigationProperty.getNullable();
    }

    public Boolean containsTarget() {
        return this.navigationProperty.isContainsTarget();
    }

    protected String internatGetPartner() {
        return this.navigationProperty.getPartner();
    }

    public String getReferencingPropertyName(String referencedPropertyName) {
        List referentialConstraints = this.navigationProperty.getReferentialConstraints();
        if (referentialConstraints != null) {
            for (ReferentialConstraint constraint : referentialConstraints) {
                if (!constraint.getReferencedProperty().equals(referencedPropertyName)) continue;
                return constraint.getProperty();
            }
        }
        return null;
    }

    public List<EdmReferentialConstraint> getReferentialConstraints() {
        if (this.referentialConstraints == null) {
            List providerConstraints = this.navigationProperty.getReferentialConstraints();
            this.referentialConstraints = new ArrayList();
            if (providerConstraints != null) {
                for (ReferentialConstraint constraint : providerConstraints) {
                    this.referentialConstraints.add(new EdmReferentialConstraintImpl(constraint.getProperty(), constraint.getReferencedProperty()));
                }
            }
        }
        return this.referentialConstraints;
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

