/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.List;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.AbstractEdmProperty;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.server.api.edm.provider.Property;

public class EdmPropertyImpl
extends AbstractEdmProperty {
    private final FullQualifiedName structuredTypeName;
    private final Property property;
    private final EdmTypeInfo typeInfo;

    public EdmPropertyImpl(Edm edm, FullQualifiedName structuredTypeName, Property property) {
        super(edm, property.getName());
        this.structuredTypeName = structuredTypeName;
        this.property = property;
        this.typeInfo = new EdmTypeInfo.Builder().setEdm(edm).setTypeExpression(property.getType().toString()).build();
    }

    public EdmTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public boolean isCollection() {
        return this.property.isCollection();
    }

    public EdmMapping getMapping() {
        return this.property.getMapping();
    }

    public String getMimeType() {
        return this.property.getMimeType();
    }

    public Boolean isNullable() {
        return this.property.getNullable();
    }

    public Integer getMaxLength() {
        return this.property.getMaxLength();
    }

    public Integer getPrecision() {
        return this.property.getPrecision();
    }

    public Integer getScale() {
        return this.property.getScale();
    }

    public SRID getSrid() {
        return null;
    }

    public Boolean isUnicode() {
        return this.property.isUnicode();
    }

    public String getDefaultValue() {
        return this.property.getDefaultValue();
    }

    public FullQualifiedName getAnnotationsTargetFQN() {
        return this.structuredTypeName;
    }

    public EdmAnnotation getAnnotation(EdmTerm term) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<EdmAnnotation> getAnnotations() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

