/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmAnnotation;
import org.apache.olingo.commons.api.edm.EdmAnnotations;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityContainer;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmSchema;
import org.apache.olingo.commons.api.edm.EdmServiceMetadata;
import org.apache.olingo.commons.api.edm.EdmTerm;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.core.edm.AbstractEdm;
import org.apache.olingo.server.api.edm.provider.Action;
import org.apache.olingo.server.api.edm.provider.AliasInfo;
import org.apache.olingo.server.api.edm.provider.ComplexType;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.EnumType;
import org.apache.olingo.server.api.edm.provider.Function;
import org.apache.olingo.server.api.edm.provider.Parameter;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.edm.provider.TypeDefinition;
import org.apache.olingo.server.core.edm.provider.EdmActionImpl;
import org.apache.olingo.server.core.edm.provider.EdmComplexTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmEntityContainerImpl;
import org.apache.olingo.server.core.edm.provider.EdmEntityTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmEnumTypeImpl;
import org.apache.olingo.server.core.edm.provider.EdmFunctionImpl;
import org.apache.olingo.server.core.edm.provider.EdmSchemaImpl;
import org.apache.olingo.server.core.edm.provider.EdmServiceMetadataImpl;
import org.apache.olingo.server.core.edm.provider.EdmTypeDefinitionImpl;

public class EdmProviderImpl
extends AbstractEdm {
    private final EdmProvider provider;
    private final Map<FullQualifiedName, List<Action>> actionsMap = new HashMap();
    private final Map<FullQualifiedName, List<Function>> functionsMap = new HashMap();

    public EdmProviderImpl(EdmProvider provider) {
        this.provider = provider;
    }

    public EdmEntityContainer createEntityContainer(FullQualifiedName containerName) {
        try {
            EntityContainerInfo entityContainerInfo = this.provider.getEntityContainerInfo(containerName);
            if (entityContainerInfo != null) {
                return new EdmEntityContainerImpl((Edm)this, this.provider, entityContainerInfo);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmEnumType createEnumType(FullQualifiedName enumName) {
        try {
            EnumType enumType = this.provider.getEnumType(enumName);
            if (enumType != null) {
                return new EdmEnumTypeImpl((Edm)this, enumName, enumType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmTypeDefinition createTypeDefinition(FullQualifiedName typeDefinitionName) {
        try {
            TypeDefinition typeDefinition = this.provider.getTypeDefinition(typeDefinitionName);
            if (typeDefinition != null) {
                return new EdmTypeDefinitionImpl((Edm)this, typeDefinitionName, typeDefinition);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmEntityType createEntityType(FullQualifiedName entityTypeName) {
        try {
            EntityType entityType = this.provider.getEntityType(entityTypeName);
            if (entityType != null) {
                return EdmEntityTypeImpl.getInstance((Edm)this, (FullQualifiedName)entityTypeName, (EntityType)entityType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmComplexType createComplexType(FullQualifiedName complexTypeName) {
        try {
            ComplexType complexType = this.provider.getComplexType(complexTypeName);
            if (complexType != null) {
                return EdmComplexTypeImpl.getInstance((Edm)this, (FullQualifiedName)complexTypeName, (ComplexType)complexType);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmAction createBoundAction(FullQualifiedName actionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection) {
        try {
            List actions = (List)this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (Action action : actions) {
                List parameters;
                Parameter parameter;
                if (!action.isBound() || !bindingParameterTypeName.equals((Object)(parameter = (Parameter)(parameters = action.getParameters()).get(0)).getType()) || isBindingParameterCollection.booleanValue() != parameter.isCollection()) continue;
                return EdmActionImpl.getInstance((Edm)this, (FullQualifiedName)actionName, (Action)action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmFunction createBoundFunction(FullQualifiedName functionName, FullQualifiedName bindingParameterTypeName, Boolean isBindingParameterCollection, List<String> parameterNames) {
        try {
            List functions = (List)this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (Function function : functions) {
                if (!function.isBound()) continue;
                List providerParameters = function.getParameters();
                if (providerParameters == null || providerParameters.size() == 0) {
                    throw new EdmException("No parameter specified for bound function: " + functionName);
                }
                Parameter bindingParameter = (Parameter)providerParameters.get(0);
                if (!bindingParameterTypeName.equals((Object)bindingParameter.getType()) || isBindingParameterCollection.booleanValue() != bindingParameter.isCollection() || parameterNamesCopy.size() != providerParameters.size() - 1) continue;
                ArrayList<String> providerParameterNames = new ArrayList<String>();
                for (int i = 1; i < providerParameters.size(); ++i) {
                    providerParameterNames.add(((Parameter)providerParameters.get(i)).getName());
                }
                if (!parameterNamesCopy.containsAll(providerParameterNames)) continue;
                return EdmFunctionImpl.getInstance((Edm)this, (FullQualifiedName)functionName, (Function)function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    public EdmServiceMetadata createServiceMetadata() {
        return new EdmServiceMetadataImpl(this.provider);
    }

    protected Map<String, String> createAliasToNamespaceInfo() {
        HashMap<String, String> aliasToNamespaceInfos = new HashMap<String, String>();
        try {
            List aliasInfos = this.provider.getAliasInfos();
            if (aliasInfos != null) {
                for (AliasInfo info : aliasInfos) {
                    aliasToNamespaceInfos.put(info.getAlias(), info.getNamespace());
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return aliasToNamespaceInfos;
    }

    protected EdmAction createUnboundAction(FullQualifiedName actionName) {
        try {
            List actions = (List)this.actionsMap.get(actionName);
            if (actions == null) {
                actions = this.provider.getActions(actionName);
                if (actions == null) {
                    return null;
                }
                this.actionsMap.put(actionName, actions);
            }
            for (Action action : actions) {
                if (action.isBound()) continue;
                return EdmActionImpl.getInstance((Edm)this, (FullQualifiedName)actionName, (Action)action);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    protected List<EdmFunction> createUnboundFunctions(FullQualifiedName functionName) {
        ArrayList<EdmFunction> result = new ArrayList<EdmFunction>();
        try {
            List functions = (List)this.functionsMap.get(functionName);
            if (functions == null && (functions = this.provider.getFunctions(functionName)) != null) {
                this.functionsMap.put(functionName, functions);
            }
            if (functions != null) {
                for (Function function : functions) {
                    if (function.isBound()) continue;
                    result.add((EdmFunction)EdmFunctionImpl.getInstance((Edm)this, (FullQualifiedName)functionName, (Function)function));
                }
            }
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
        return result;
    }

    protected EdmFunction createUnboundFunction(FullQualifiedName functionName, List<String> parameterNames) {
        try {
            List functions = (List)this.functionsMap.get(functionName);
            if (functions == null) {
                functions = this.provider.getFunctions(functionName);
                if (functions == null) {
                    return null;
                }
                this.functionsMap.put(functionName, functions);
            }
            List<Object> parameterNamesCopy = parameterNames == null ? Collections.emptyList() : parameterNames;
            for (Function function : functions) {
                if (function.isBound()) continue;
                List<Parameter> providerParameters = function.getParameters();
                if (providerParameters == null) {
                    providerParameters = Collections.emptyList();
                }
                if (parameterNamesCopy.size() != providerParameters.size()) continue;
                ArrayList<String> functionParameterNames = new ArrayList<String>();
                for (Parameter parameter : providerParameters) {
                    functionParameterNames.add(parameter.getName());
                }
                if (!parameterNamesCopy.containsAll(functionParameterNames)) continue;
                return EdmFunctionImpl.getInstance((Edm)this, (FullQualifiedName)functionName, (Function)function);
            }
            return null;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    protected Map<String, EdmSchema> createSchemas() {
        try {
            LinkedHashMap<String, EdmSchema> _schemas = new LinkedHashMap<String, EdmSchema>();
            for (Schema schema : this.provider.getSchemas()) {
                _schemas.put(schema.getNamespace(), (EdmSchema)new EdmSchemaImpl((Edm)this, this.provider, schema));
            }
            return _schemas;
        }
        catch (ODataException e) {
            throw new EdmException((Exception)((Object)e));
        }
    }

    protected EdmTerm createTerm(FullQualifiedName termName) {
        return null;
    }

    protected EdmAnnotations createAnnotationGroup(FullQualifiedName targetName) {
        return null;
    }

    protected List<EdmAnnotation> createAnnotations(FullQualifiedName annotatedName) {
        return null;
    }
}

