/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.edm.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.EdmActionImportInfo;
import org.apache.olingo.commons.api.edm.EdmEntitySetInfo;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmFunctionImportInfo;
import org.apache.olingo.commons.api.edm.EdmServiceMetadata;
import org.apache.olingo.commons.api.edm.EdmSingletonInfo;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.core.edm.EdmActionImportInfoImpl;
import org.apache.olingo.commons.core.edm.EdmEntitySetInfoImpl;
import org.apache.olingo.commons.core.edm.EdmFunctionImportInfoImpl;
import org.apache.olingo.commons.core.edm.EdmSingletonInfoImpl;
import org.apache.olingo.server.api.edm.provider.ActionImport;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityContainer;
import org.apache.olingo.server.api.edm.provider.EntitySet;
import org.apache.olingo.server.api.edm.provider.FunctionImport;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.edm.provider.Singleton;

public class EdmServiceMetadataImpl
implements EdmServiceMetadata {
    private EdmProvider provider;
    private List<Schema> schemas;
    private List<EdmEntitySetInfo> entitySetInfos;
    private List<EdmSingletonInfo> singletonInfos;
    private List<EdmActionImportInfo> actionImportInfos;
    private List<EdmFunctionImportInfo> functionImportInfos;

    public EdmServiceMetadataImpl(EdmProvider provider) {
        this.provider = provider;
    }

    public InputStream getMetadata() {
        throw new RuntimeException("Not yet implemented");
    }

    public ODataServiceVersion getDataServiceVersion() {
        return ODataServiceVersion.V40;
    }

    public List<EdmEntitySetInfo> getEntitySetInfos() {
        if (this.entitySetInfos == null) {
            try {
                this.entitySetInfos = new ArrayList();
                if (this.schemas == null) {
                    this.schemas = this.provider.getSchemas();
                    if (this.schemas == null) {
                        throw new EdmException("Provider doe not define any schemas.");
                    }
                }
                for (Schema schema : this.schemas) {
                    List entitySets;
                    EntityContainer entityContainer = schema.getEntityContainer();
                    if (entityContainer == null || (entitySets = entityContainer.getEntitySets()) == null) continue;
                    for (EntitySet set : entitySets) {
                        this.entitySetInfos.add(new EdmEntitySetInfoImpl(entityContainer.getName(), set.getName()));
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
        return this.entitySetInfos;
    }

    public List<EdmSingletonInfo> getSingletonInfos() {
        if (this.singletonInfos == null) {
            try {
                this.singletonInfos = new ArrayList();
                if (this.schemas == null) {
                    this.schemas = this.provider.getSchemas();
                    if (this.schemas == null) {
                        throw new EdmException("Provider doe not define any schemas.");
                    }
                }
                for (Schema schema : this.schemas) {
                    List singletons;
                    EntityContainer entityContainer = schema.getEntityContainer();
                    if (entityContainer == null || (singletons = entityContainer.getSingletons()) == null) continue;
                    for (Singleton singleton : singletons) {
                        this.singletonInfos.add(new EdmSingletonInfoImpl(entityContainer.getName(), singleton.getName()));
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
        return this.singletonInfos;
    }

    public List<EdmActionImportInfo> getActionImportInfos() {
        if (this.actionImportInfos == null) {
            try {
                this.actionImportInfos = new ArrayList();
                if (this.schemas == null) {
                    this.schemas = this.provider.getSchemas();
                    if (this.schemas == null) {
                        throw new EdmException("Provider doe not define any schemas.");
                    }
                }
                for (Schema schema : this.schemas) {
                    List actionImports;
                    EntityContainer entityContainer = schema.getEntityContainer();
                    if (entityContainer == null || (actionImports = entityContainer.getActionImports()) == null) continue;
                    for (ActionImport actionImport : actionImports) {
                        this.actionImportInfos.add(new EdmActionImportInfoImpl(entityContainer.getName(), actionImport.getName()));
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
        return this.actionImportInfos;
    }

    public List<EdmFunctionImportInfo> getFunctionImportInfos() {
        if (this.functionImportInfos == null) {
            try {
                this.functionImportInfos = new ArrayList();
                if (this.schemas == null) {
                    this.schemas = this.provider.getSchemas();
                    if (this.schemas == null) {
                        throw new EdmException("Provider doe not define any schemas.");
                    }
                }
                for (Schema schema : this.schemas) {
                    List functionImports;
                    EntityContainer entityContainer = schema.getEntityContainer();
                    if (entityContainer == null || (functionImports = entityContainer.getFunctionImports()) == null) continue;
                    for (FunctionImport functionImport : functionImports) {
                        this.functionImportInfos.add(new EdmFunctionImportInfoImpl(entityContainer.getName(), functionImport.getName()));
                    }
                }
            }
            catch (ODataException e) {
                throw new EdmException((Exception)((Object)e));
            }
        }
        return this.functionImportInfos;
    }
}

