/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer;

import java.io.InputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.ODataSerializerException;
import org.apache.olingo.server.core.serializer.utils.CircleStreamBuffer;
import org.apache.olingo.server.core.serializer.xml.MetadataDocumentXmlSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataXmlSerializerImpl
implements ODataSerializer {
    private static final Logger log = LoggerFactory.getLogger(ODataXmlSerializerImpl.class);

    public InputStream serviceDocument(Edm edm, String serviceRoot) throws ODataSerializerException {
        throw new ODataSerializerException("Service Document not implemented for XML format", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream metadataDocument(Edm edm) throws ODataSerializerException {
        XMLStreamWriter xmlStreamWriter = null;
        try {
            CircleStreamBuffer buffer = new CircleStreamBuffer();
            xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(buffer.getOutputStream(), "UTF-8");
            MetadataDocumentXmlSerializer serializer = new MetadataDocumentXmlSerializer(edm);
            serializer.writeMetadataDocument(xmlStreamWriter);
            xmlStreamWriter.flush();
            xmlStreamWriter.close();
            InputStream inputStream = buffer.getInputStream();
            return inputStream;
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            if (xmlStreamWriter != null) {
                try {
                    xmlStreamWriter.close();
                }
                catch (XMLStreamException e) {
                    throw new ODataSerializerException("An I/O exception occurred.", (Throwable)e, (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.IO_EXCEPTION, new String[0]);
                }
            }
        }
    }

    public InputStream entity(EdmEntitySet edmEntitySet, Entity entity, ContextURL contextURL) throws ODataSerializerException {
        throw new ODataSerializerException("Entity serialization not implemented for XML format", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream entitySet(EdmEntitySet edmEntitySet, EntitySet entitySet, ContextURL contextURL) throws ODataSerializerException {
        throw new ODataSerializerException("Entityset serialization not implemented for XML format", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }

    public InputStream error(ODataServerError error) throws ODataSerializerException {
        throw new ODataSerializerException("error serialization not implemented for XML format", (ODataTranslatedException.MessageKey)ODataSerializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
    }
}

