/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.core.uri.UriParameterImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;

public class UriResourceFunctionImpl
extends UriResourceWithKeysImpl
implements UriResourceFunction {
    protected List<UriParameterImpl> parameters;
    protected EdmFunction function;
    protected EdmFunctionImport functionImport;
    private boolean isParameterListFilled = false;

    public UriResourceFunctionImpl() {
        super(UriResourceKind.function);
    }

    public List<UriParameter> getParameters() {
        ArrayList<UriParameter> retList = new ArrayList<UriParameter>();
        for (UriParameterImpl item : this.parameters) {
            retList.add((UriParameter)item);
        }
        return retList;
    }

    public UriResourceFunctionImpl setParameters(List<UriParameterImpl> parameters) {
        this.isParameterListFilled = true;
        this.parameters = parameters;
        return this;
    }

    public EdmFunction getFunction() {
        return this.function;
    }

    public UriResourceFunctionImpl setFunction(EdmFunction function) {
        this.function = function;
        return this;
    }

    public EdmFunctionImport getFunctionImport() {
        return this.functionImport;
    }

    public UriResourceFunctionImpl setFunctionImport(EdmFunctionImport edmFI, List<UriParameterImpl> parameters) {
        this.functionImport = edmFI;
        this.setParameters(parameters);
        return this;
    }

    public EdmType getType() {
        return this.function.getReturnType().getType();
    }

    public boolean isCollection() {
        if (this.keyPredicates != null) {
            return false;
        }
        return this.function.getReturnType().isCollection();
    }

    public String toString() {
        if (this.functionImport != null) {
            return this.functionImport.getName();
        }
        if (this.function != null) {
            return this.function.getName();
        }
        return "";
    }

    public boolean isParameterListFilled() {
        return this.isParameterListFilled;
    }
}

