/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.core.uri.UriParameterImpl;
import org.apache.olingo.server.core.uri.UriResourceImpl;

public abstract class UriResourceWithKeysImpl
extends UriResourceImpl
implements UriResourcePartTyped {
    protected EdmType collectionTypeFilter = null;
    protected List<UriParameterImpl> keyPredicates = null;
    protected EdmType entryTypeFilter = null;

    public UriResourceWithKeysImpl(UriResourceKind kind) {
        super(kind);
    }

    public EdmType getTypeFilterOnCollection() {
        return this.collectionTypeFilter;
    }

    public EdmType getTypeFilterOnEntry() {
        return this.entryTypeFilter;
    }

    public List<UriParameter> getKeyPredicates() {
        ArrayList<UriParameter> retList = new ArrayList<UriParameter>();
        if (this.keyPredicates != null) {
            for (UriParameterImpl item : this.keyPredicates) {
                retList.add((UriParameter)item);
            }
        }
        return retList;
    }

    public UriResourceWithKeysImpl setKeyPredicates(List<UriParameterImpl> list) {
        this.keyPredicates = list;
        return this;
    }

    public UriResourceWithKeysImpl setEntryTypeFilter(EdmType entryTypeFilter) {
        this.entryTypeFilter = entryTypeFilter;
        return this;
    }

    public UriResourceWithKeysImpl setCollectionTypeFilter(EdmType collectionTypeFilter) {
        this.collectionTypeFilter = collectionTypeFilter;
        return this;
    }

    public String toString(boolean includeFilters) {
        if (includeFilters) {
            String tmp = "";
            if (this.collectionTypeFilter != null) {
                tmp = tmp + this.getFQN(this.collectionTypeFilter).toString();
            }
            if (this.entryTypeFilter != null) {
                tmp = tmp.length() == 0 ? this.getFQN(this.entryTypeFilter).toString() : tmp + "/()" + this.getFQN(this.entryTypeFilter).toString();
            }
            if (tmp.length() != 0) {
                return this.toString() + "/" + tmp;
            }
        }
        return this.toString();
    }

    private FullQualifiedName getFQN(EdmType type) {
        return new FullQualifiedName(type.getNamespace(), type.getName());
    }
}

