/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.tecsvc.data;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.core.data.EntityImpl;
import org.apache.olingo.commons.core.data.EntitySetImpl;
import org.apache.olingo.commons.core.data.LinkedComplexValueImpl;
import org.apache.olingo.commons.core.data.PropertyImpl;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.tecsvc.data.DataProvider;

public class DataProvider {
    private static final UUID GUID = UUID.fromString("01234567-89ab-cdef-0123-456789abcdef");
    private final Edm edm;
    private Map<String, EntitySet> data;

    public DataProvider(Edm edm) {
        this.edm = edm;
        this.data = new HashMap();
        this.data.put("ESTwoPrim", this.createESTwoPrim());
        this.data.put("ESAllPrim", this.createESAllPrim());
        this.data.put("ESCompAllPrim", this.createESCompAllPrim());
        this.data.put("ESCollAllPrim", this.createESCollAllPrim());
        this.data.put("ESMixPrimCollComp", this.createESMixPrimCollComp());
        this.data.put("ESAllKey", this.createESAllKey());
        this.data.put("ESMedia", this.createESMedia());
    }

    public EntitySet readAll(EdmEntitySet edmEntitySet) throws DataProviderException {
        return (EntitySet)this.data.get(edmEntitySet.getName());
    }

    public Entity read(EdmEntitySet edmEntitySet, List<UriParameter> keys) throws DataProviderException {
        EdmEntityType entityType = edmEntitySet.getEntityType();
        EntitySet entitySet = (EntitySet)this.data.get(edmEntitySet.getName());
        if (entitySet == null) {
            return null;
        }
        try {
            for (Entity entity : entitySet.getEntities()) {
                boolean found = true;
                for (UriParameter key : keys) {
                    EdmProperty property = (EdmProperty)entityType.getProperty(key.getName());
                    EdmPrimitiveType type = (EdmPrimitiveType)property.getType();
                    if (type.valueToString(entity.getProperty(key.getName()).getValue(), property.isNullable(), property.getMaxLength(), property.getPrecision(), property.getScale(), property.isUnicode()).equals(key.getText())) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return entity;
            }
            return null;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DataProviderException("Wrong key!", (Throwable)e);
        }
    }

    private EntitySet createESTwoPrim() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)32766));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Test String1"));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)-365));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Test String2"));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)-32766));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Test String3"));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Test String4"));
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private EntitySet createESAllPrim() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"First Resource - positive values"));
        entity.addProperty(this.createPrimitive("PropertyBoolean", (Object)true));
        entity.addProperty(this.createPrimitive("PropertyByte", (Object)255));
        entity.addProperty(this.createPrimitive("PropertySByte", (Object)127));
        entity.addProperty(this.createPrimitive("PropertyInt32", (Object)Integer.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyInt64", (Object)Long.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertySingle", (Object)1.79E20));
        entity.addProperty(this.createPrimitive("PropertyDouble", (Object)-1.79E19));
        entity.addProperty(this.createPrimitive("PropertyDecimal", (Object)34));
        entity.addProperty(this.createPrimitive("PropertyBinary", (Object)new byte[]{1, 35, 69, 103, -119, -85, -51, -17}));
        entity.addProperty(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2012, 12, 3, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2012, 12, 3, 7, 16, 23)));
        entity.addProperty(this.createPrimitive("PropertyDuration", (Object)6));
        entity.addProperty(this.createPrimitive("PropertyGuid", (Object)GUID));
        entity.addProperty(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(3, 26, 5)));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MIN_VALUE));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Second Resource - negative values"));
        entity.addProperty(this.createPrimitive("PropertyBoolean", (Object)false));
        entity.addProperty(this.createPrimitive("PropertyByte", (Object)0));
        entity.addProperty(this.createPrimitive("PropertySByte", (Object)-128));
        entity.addProperty(this.createPrimitive("PropertyInt32", (Object)Integer.MIN_VALUE));
        entity.addProperty(this.createPrimitive("PropertyInt64", (Object)Long.MIN_VALUE));
        entity.addProperty(this.createPrimitive("PropertySingle", (Object)-1.79E8));
        entity.addProperty(this.createPrimitive("PropertyDouble", (Object)-179000.0));
        entity.addProperty(this.createPrimitive("PropertyDecimal", (Object)-34));
        entity.addProperty(this.createPrimitive("PropertyBinary", (Object)new byte[]{1, 35, 69, 103, -119, -85, -51, -17}));
        entity.addProperty(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2015, 11, 5, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2005, 12, 3, 7, 17, 8)));
        entity.addProperty(this.createPrimitive("PropertyDuration", (Object)9));
        entity.addProperty(this.createPrimitive("PropertyGuid", (Object)UUID.fromString("76543201-23ab-cdef-0123-456789dddfff")));
        entity.addProperty(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(23, 49, 14)));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyString", (Object)""));
        entity.addProperty(this.createPrimitive("PropertyBoolean", (Object)false));
        entity.addProperty(this.createPrimitive("PropertyByte", (Object)0));
        entity.addProperty(this.createPrimitive("PropertySByte", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyInt32", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyInt64", (Object)0));
        entity.addProperty(this.createPrimitive("PropertySingle", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyDouble", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyDecimal", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyBinary", (Object)new byte[0]));
        entity.addProperty(this.createPrimitive("PropertyDate", (Object)this.getDateTime(1970, 1, 1, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2005, 12, 3, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDuration", (Object)0));
        entity.addProperty(this.createPrimitive("PropertyGuid", (Object)UUID.fromString("76543201-23ab-cdef-0123-456789cccddd")));
        entity.addProperty(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(0, 1, 1)));
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private EntitySet createESCompAllPrim() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        LinkedComplexValueImpl complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"First Resource - first"));
        complexValue.getValue().add(this.createPrimitive("PropertyBinary", (Object)new byte[]{1, 35, 69, 103, -119, -85, -51, -17}));
        complexValue.getValue().add(this.createPrimitive("PropertyBoolean", (Object)true));
        complexValue.getValue().add(this.createPrimitive("PropertyByte", (Object)255));
        complexValue.getValue().add(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2012, 10, 3, 0, 0, 0)));
        complexValue.getValue().add(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getTimestamp(2012, 10, 3, 7, 16, 23, 123456700)));
        complexValue.getValue().add(this.createPrimitive("PropertyDecimal", (Object)34.27));
        complexValue.getValue().add(this.createPrimitive("PropertySingle", (Object)1.79E20));
        complexValue.getValue().add(this.createPrimitive("PropertyDouble", (Object)-1.79E19));
        complexValue.getValue().add(this.createPrimitive("PropertyDuration", (Object)6));
        complexValue.getValue().add(this.createPrimitive("PropertyGuid", (Object)GUID));
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertyInt32", (Object)Integer.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertyInt64", (Object)Long.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertySByte", (Object)127));
        complexValue.getValue().add(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(1, 0, 1)));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)7));
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"Second Resource - second"));
        complexValue.getValue().add(this.createPrimitive("PropertyBinary", (Object)new byte[]{1, 35, 69, 103, -119, -85, -51, -17}));
        complexValue.getValue().add(this.createPrimitive("PropertyBoolean", (Object)true));
        complexValue.getValue().add(this.createPrimitive("PropertyByte", (Object)255));
        complexValue.getValue().add(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2013, 11, 4, 0, 0, 0)));
        complexValue.getValue().add(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2013, 11, 4, 7, 16, 23)));
        complexValue.getValue().add(this.createPrimitive("PropertyDecimal", (Object)34.27));
        complexValue.getValue().add(this.createPrimitive("PropertySingle", (Object)1.79E20));
        complexValue.getValue().add(this.createPrimitive("PropertyDouble", (Object)-179.0));
        complexValue.getValue().add(this.createPrimitive("PropertyDuration", (Object)6));
        complexValue.getValue().add(this.createPrimitive("PropertyGuid", (Object)GUID));
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)25));
        complexValue.getValue().add(this.createPrimitive("PropertyInt32", (Object)Integer.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertyInt64", (Object)Long.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertySByte", (Object)127));
        complexValue.getValue().add(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTimestamp(1, 1, 1, 7, 45, 12, 765432100)));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)0));
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"Third Resource - third"));
        complexValue.getValue().add(this.createPrimitive("PropertyBinary", (Object)new byte[]{1, 35, 69, 103, -119, -85, -51, -17}));
        complexValue.getValue().add(this.createPrimitive("PropertyBoolean", (Object)true));
        complexValue.getValue().add(this.createPrimitive("PropertyByte", (Object)255));
        complexValue.getValue().add(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2014, 12, 5, 0, 0, 0)));
        complexValue.getValue().add(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getTimestamp(2014, 12, 5, 8, 17, 45, 123456700)));
        complexValue.getValue().add(this.createPrimitive("PropertyDecimal", (Object)17.98));
        complexValue.getValue().add(this.createPrimitive("PropertySingle", (Object)1.79E20));
        complexValue.getValue().add(this.createPrimitive("PropertyDouble", (Object)-179.0));
        complexValue.getValue().add(this.createPrimitive("PropertyDuration", (Object)6));
        complexValue.getValue().add(this.createPrimitive("PropertyGuid", (Object)GUID));
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)-25));
        complexValue.getValue().add(this.createPrimitive("PropertyInt32", (Object)Integer.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertyInt64", (Object)Long.MAX_VALUE));
        complexValue.getValue().add(this.createPrimitive("PropertySByte", (Object)127));
        complexValue.getValue().add(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(13, 27, 45)));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private EntitySet createESCollAllPrim() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)1));
        entity.addProperty(this.createCollection("CollPropertyString", new Object[]{"Employee1@company.example", "Employee2@company.example", "Employee3@company.example"}));
        entity.addProperty(this.createCollection("CollPropertyBoolean", new Object[]{true, false, true}));
        entity.addProperty(this.createCollection("CollPropertyByte", new Object[]{50, 200, 249}));
        entity.addProperty(this.createCollection("CollPropertySByte", new Object[]{-120, 120, 126}));
        entity.addProperty(this.createCollection("CollPropertyInt16", new Object[]{1000, 2000, 30112}));
        entity.addProperty(this.createCollection("CollPropertyInt32", new Object[]{23232323, 11223355, 10000001}));
        entity.addProperty(this.createCollection("CollPropertyInt64", new Object[]{929292929292L, 333333333333L, 444444444444L}));
        entity.addProperty(this.createCollection("CollPropertySingle", new Object[]{1790.0, 26600.0, 3210.0}));
        entity.addProperty(this.createCollection("CollPropertyDouble", new Object[]{-17900.0, -2.78E7, 3210.0}));
        entity.addProperty(this.createCollection("CollPropertyDecimal", new Object[]{12, -2, 1234}));
        entity.addProperty(this.createCollection("CollPropertyBinary", new Object[]{new byte[]{-85, -51, -17}, new byte[]{1, 35, 69}, new byte[]{84, 103, -119}}));
        entity.addProperty(this.createCollection("CollPropertyDate", new Object[]{this.getDateTime(1958, 12, 3, 0, 0, 0), this.getDateTime(1999, 8, 5, 0, 0, 0), this.getDateTime(2013, 6, 25, 0, 0, 0)}));
        entity.addProperty(this.createCollection("CollPropertyDateTimeOffset", new Object[]{this.getDateTime(2015, 8, 12, 3, 8, 34), this.getDateTime(1970, 3, 28, 12, 11, 10), this.getDateTime(1948, 2, 17, 9, 9, 9)}));
        entity.addProperty(this.createCollection("CollPropertyDuration", new Object[]{13, 19680, 3600}));
        entity.addProperty(this.createCollection("CollPropertyGuid", new Object[]{UUID.fromString("ffffff67-89ab-cdef-0123-456789aaaaaa"), UUID.fromString("eeeeee67-89ab-cdef-0123-456789bbbbbb"), UUID.fromString("cccccc67-89ab-cdef-0123-456789cccccc")}));
        entity.addProperty(this.createCollection("CollPropertyTimeOfDay", new Object[]{this.getTime(4, 14, 13), this.getTime(23, 59, 59), this.getTime(1, 12, 33)}));
        entitySet.getEntities().add(entity);
        EntityImpl entity2 = new EntityImpl();
        entity2.getProperties().addAll(entity.getProperties());
        entity2.getProperties().set(0, this.createPrimitive("PropertyInt16", (Object)2));
        entitySet.getEntities().add(entity2);
        entity2 = new EntityImpl();
        entity2.getProperties().addAll(entity.getProperties());
        entity2.getProperties().set(0, this.createPrimitive("PropertyInt16", (Object)3));
        entitySet.getEntities().add(entity2);
        return entitySet;
    }

    private EntitySet createESMixPrimCollComp() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        entity.addProperty(this.createCollection("CollPropertyString", new Object[]{"Employee1@company.example", "Employee2@company.example", "Employee3@company.example"}));
        LinkedComplexValueImpl complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)111));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST A"));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        ArrayList<LinkedComplexValueImpl> complexCollection = new ArrayList<LinkedComplexValueImpl>();
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)123));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST 1"));
        complexCollection.add(complexValue);
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)456));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST 2"));
        complexCollection.add(complexValue);
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)789));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST 3"));
        complexCollection.add(complexValue);
        entity.addProperty((Property)new PropertyImpl(null, "CollPropertyComp", ValueType.COLLECTION_LINKED_COMPLEX, complexCollection));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)7));
        entity.addProperty(this.createCollection("CollPropertyString", new Object[]{"Employee1@company.example", "Employee2@company.example", "Employee3@company.example"}));
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)222));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST B"));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        entity.addProperty((Property)new PropertyImpl(null, "CollPropertyComp", ValueType.COLLECTION_LINKED_COMPLEX, complexCollection));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)0));
        entity.addProperty(this.createCollection("CollPropertyString", new Object[]{"Employee1@company.example", "Employee2@company.example", "Employee3@company.example"}));
        complexValue = new LinkedComplexValueImpl();
        complexValue.getValue().add(this.createPrimitive("PropertyInt16", (Object)333));
        complexValue.getValue().add(this.createPrimitive("PropertyString", (Object)"TEST C"));
        entity.addProperty((Property)new PropertyImpl(null, "PropertyComp", ValueType.LINKED_COMPLEX, (Object)complexValue));
        entity.addProperty((Property)new PropertyImpl(null, "CollPropertyComp", ValueType.COLLECTION_LINKED_COMPLEX, complexCollection));
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private EntitySet createESAllKey() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"First"));
        entity.addProperty(this.createPrimitive("PropertyBoolean", (Object)true));
        entity.addProperty(this.createPrimitive("PropertyByte", (Object)255));
        entity.addProperty(this.createPrimitive("PropertySByte", (Object)127));
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)Short.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyInt32", (Object)Integer.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyInt64", (Object)Long.MAX_VALUE));
        entity.addProperty(this.createPrimitive("PropertyDecimal", (Object)34));
        entity.addProperty(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2012, 12, 3, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2012, 12, 3, 7, 16, 23)));
        entity.addProperty(this.createPrimitive("PropertyDuration", (Object)6));
        entity.addProperty(this.createPrimitive("PropertyGuid", (Object)GUID));
        entity.addProperty(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(2, 48, 21)));
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyString", (Object)"Second"));
        entity.addProperty(this.createPrimitive("PropertyBoolean", (Object)true));
        entity.addProperty(this.createPrimitive("PropertyByte", (Object)254));
        entity.addProperty(this.createPrimitive("PropertySByte", (Object)124));
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)32764));
        entity.addProperty(this.createPrimitive("PropertyInt32", (Object)0x7FFFFFFC));
        entity.addProperty(this.createPrimitive("PropertyInt64", (Object)0x7FFFFFFFFFFFFFFCL));
        entity.addProperty(this.createPrimitive("PropertyDecimal", (Object)34));
        entity.addProperty(this.createPrimitive("PropertyDate", (Object)this.getDateTime(2012, 12, 3, 0, 0, 0)));
        entity.addProperty(this.createPrimitive("PropertyDateTimeOffset", (Object)this.getDateTime(2012, 12, 3, 7, 16, 23)));
        entity.addProperty(this.createPrimitive("PropertyDuration", (Object)6));
        entity.addProperty(this.createPrimitive("PropertyGuid", (Object)GUID));
        entity.addProperty(this.createPrimitive("PropertyTimeOfDay", (Object)this.getTime(2, 48, 21)));
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private EntitySet createESMedia() {
        EntitySetImpl entitySet = new EntitySetImpl();
        EntityImpl entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)1));
        entity.setMediaContentType("image/png");
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)2));
        entity.setMediaContentType("image/bmp");
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)3));
        entity.setMediaContentType("image/jpeg");
        entitySet.getEntities().add(entity);
        entity = new EntityImpl();
        entity.addProperty(this.createPrimitive("PropertyInt16", (Object)4));
        entity.setMediaContentType("foo");
        entitySet.getEntities().add(entity);
        return entitySet;
    }

    private Property createPrimitive(String name, Object value) {
        return new PropertyImpl(null, name, ValueType.PRIMITIVE, value);
    }

    private Property createCollection(String name, Object ... values) {
        return new PropertyImpl(null, name, ValueType.COLLECTION_PRIMITIVE, Arrays.asList(values));
    }

    private Calendar getDateTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar dateTime = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        dateTime.clear();
        dateTime.set(year, month - 1, day, hour, minute, second);
        return dateTime;
    }

    private Calendar getTime(int hour, int minute, int second) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        time.clear();
        time.set(11, hour);
        time.set(12, minute);
        time.set(13, second);
        return time;
    }

    private Timestamp getTimestamp(int year, int month, int day, int hour, int minute, int second, int nanosecond) {
        Timestamp timestamp = new Timestamp(this.getDateTime(year, month, day, hour, minute, second).getTimeInMillis());
        timestamp.setNanos(nanosecond);
        return timestamp;
    }
}

