/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.tecsvc.processor;

import java.util.List;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntitySet;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.format.ODataFormat;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataTranslatedException;
import org.apache.olingo.server.api.processor.EntityCollectionProcessor;
import org.apache.olingo.server.api.processor.EntityProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.tecsvc.data.DataProvider;

public class TechnicalProcessor
implements EntityCollectionProcessor,
EntityProcessor {
    private OData odata;
    private Edm edm;
    private DataProvider dataProvider;

    public TechnicalProcessor(DataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void init(OData odata, Edm edm) {
        this.odata = odata;
        this.edm = edm;
    }

    public void readCollection(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) {
        if (!this.validateOptions(uriInfo.asUriInfoResource())) {
            response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
            return;
        }
        try {
            EdmEntitySet edmEntitySet = this.getEdmEntitySet(uriInfo.asUriInfoResource());
            EntitySet entitySet = this.readEntitySetInternal(edmEntitySet, request.getRawBaseUri());
            if (entitySet == null) {
                response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
            } else {
                ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
                response.setContent(serializer.entitySet(edmEntitySet, entitySet, this.getContextUrl(edmEntitySet, false)));
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                response.setHeader("Content-Type", requestedContentType.toContentTypeString());
            }
        }
        catch (DataProvider.DataProviderException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        catch (ODataTranslatedException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    public void readEntity(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType requestedContentType) {
        if (!this.validateOptions(uriInfo.asUriInfoResource())) {
            response.setStatusCode(HttpStatusCode.NOT_IMPLEMENTED.getStatusCode());
            return;
        }
        try {
            EdmEntitySet edmEntitySet = this.getEdmEntitySet(uriInfo.asUriInfoResource());
            Entity entity = this.readEntityInternal(uriInfo.asUriInfoResource(), edmEntitySet);
            if (entity == null) {
                response.setStatusCode(HttpStatusCode.NOT_FOUND.getStatusCode());
            } else {
                ODataSerializer serializer = this.odata.createSerializer(ODataFormat.fromContentType((ContentType)requestedContentType));
                response.setContent(serializer.entity(edmEntitySet, entity, this.getContextUrl(edmEntitySet, true)));
                response.setStatusCode(HttpStatusCode.OK.getStatusCode());
                response.setHeader("Content-Type", requestedContentType.toContentTypeString());
            }
        }
        catch (DataProvider.DataProviderException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        catch (ODataTranslatedException e) {
            response.setStatusCode(HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    private EntitySet readEntitySetInternal(EdmEntitySet edmEntitySet, String serviceRoot) throws DataProvider.DataProviderException {
        EntitySet entitySet = this.dataProvider.readAll(edmEntitySet);
        return entitySet;
    }

    private Entity readEntityInternal(UriInfoResource uriInfo, EdmEntitySet entitySet) throws DataProvider.DataProviderException {
        UriResourceEntitySet resourceEntitySet = (UriResourceEntitySet)uriInfo.getUriResourceParts().get(0);
        return this.dataProvider.read(entitySet, resourceEntitySet.getKeyPredicates());
    }

    private boolean validateOptions(UriInfoResource uriInfo) {
        return uriInfo.getCountOption() == null && uriInfo.getCustomQueryOptions().isEmpty() && uriInfo.getExpandOption() == null && uriInfo.getFilterOption() == null && uriInfo.getIdOption() == null && uriInfo.getOrderByOption() == null && uriInfo.getSearchOption() == null && uriInfo.getSelectOption() == null && uriInfo.getSkipOption() == null && uriInfo.getSkipTokenOption() == null && uriInfo.getTopOption() == null;
    }

    private EdmEntitySet getEdmEntitySet(UriInfoResource uriInfo) throws ODataTranslatedException {
        List resourcePaths = uriInfo.getUriResourceParts();
        if (resourcePaths.size() != 1) {
            throw new ODataTranslatedException("Invalid resource path.", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        if (!(resourcePaths.get(0) instanceof UriResourceEntitySet)) {
            throw new ODataTranslatedException("Invalid resource type.", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        UriResourceEntitySet uriResource = (UriResourceEntitySet)resourcePaths.get(0);
        if (uriResource.getTypeFilterOnCollection() != null || uriResource.getTypeFilterOnEntry() != null) {
            throw new ODataTranslatedException("Type filters are not supported.", (ODataTranslatedException.MessageKey)ODataTranslatedException.MessageKeys.FUNCTIONALITY_NOT_IMPLEMENTED, new String[0]);
        }
        return uriResource.getEntitySet();
    }

    private ContextURL getContextUrl(EdmEntitySet entitySet, boolean isSingleEntity) {
        return ContextURL.Builder.create().entitySet(entitySet).suffix((ContextURL.Suffix)(isSingleEntity ? ContextURL.Suffix.ENTITY : null)).build();
    }
}

