/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.tecsvc.provider;

import java.util.Arrays;
import java.util.List;
import org.apache.olingo.commons.api.ODataException;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.server.api.edm.provider.Action;
import org.apache.olingo.server.api.edm.provider.ActionImport;
import org.apache.olingo.server.api.edm.provider.AliasInfo;
import org.apache.olingo.server.api.edm.provider.ComplexType;
import org.apache.olingo.server.api.edm.provider.EdmProvider;
import org.apache.olingo.server.api.edm.provider.EntityContainer;
import org.apache.olingo.server.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.server.api.edm.provider.EntitySet;
import org.apache.olingo.server.api.edm.provider.EntityType;
import org.apache.olingo.server.api.edm.provider.EnumType;
import org.apache.olingo.server.api.edm.provider.Function;
import org.apache.olingo.server.api.edm.provider.FunctionImport;
import org.apache.olingo.server.api.edm.provider.Schema;
import org.apache.olingo.server.api.edm.provider.Singleton;
import org.apache.olingo.server.api.edm.provider.Term;
import org.apache.olingo.server.api.edm.provider.TypeDefinition;
import org.apache.olingo.server.tecsvc.provider.ActionProvider;
import org.apache.olingo.server.tecsvc.provider.ComplexTypeProvider;
import org.apache.olingo.server.tecsvc.provider.ContainerProvider;
import org.apache.olingo.server.tecsvc.provider.EntityTypeProvider;
import org.apache.olingo.server.tecsvc.provider.EnumTypeProvider;
import org.apache.olingo.server.tecsvc.provider.FunctionProvider;
import org.apache.olingo.server.tecsvc.provider.SchemaProvider;
import org.apache.olingo.server.tecsvc.provider.TypeDefinitionProvider;

public class EdmTechProvider
extends EdmProvider {
    public static final String nameSpace = "com.sap.odata.test1";
    private final SchemaProvider schemaProvider;
    private final EntityTypeProvider entityTypeProvider;
    private final ContainerProvider containerProvider = new ContainerProvider(this);
    private final ComplexTypeProvider complexTypeProvider;
    private final EnumTypeProvider enumTypeProvider;
    private final ActionProvider actionProvider;
    private final FunctionProvider functionProvider;
    private final TypeDefinitionProvider typeDefinitionProvider;

    public EdmTechProvider() {
        this.entityTypeProvider = new EntityTypeProvider();
        this.complexTypeProvider = new ComplexTypeProvider();
        this.enumTypeProvider = new EnumTypeProvider();
        this.actionProvider = new ActionProvider();
        this.functionProvider = new FunctionProvider();
        this.typeDefinitionProvider = new TypeDefinitionProvider();
        this.schemaProvider = new SchemaProvider(this);
    }

    public List<AliasInfo> getAliasInfos() throws ODataException {
        return Arrays.asList(new AliasInfo().setAlias("Namespace1_Alias").setNamespace(nameSpace));
    }

    public EnumType getEnumType(FullQualifiedName enumTypeName) throws ODataException {
        return this.enumTypeProvider.getEnumType(enumTypeName);
    }

    public TypeDefinition getTypeDefinition(FullQualifiedName typeDefinitionName) throws ODataException {
        return this.typeDefinitionProvider.getTypeDefinition(typeDefinitionName);
    }

    public EntityType getEntityType(FullQualifiedName entityTypeName) throws ODataException {
        return this.entityTypeProvider.getEntityType(entityTypeName);
    }

    public ComplexType getComplexType(FullQualifiedName complexTypeName) throws ODataException {
        return this.complexTypeProvider.getComplexType(complexTypeName);
    }

    public List<Action> getActions(FullQualifiedName actionName) throws ODataException {
        return this.actionProvider.getActions(actionName);
    }

    public List<Function> getFunctions(FullQualifiedName functionName) throws ODataException {
        return this.functionProvider.getFunctions(functionName);
    }

    public Term getTerm(FullQualifiedName termName) throws ODataException {
        return null;
    }

    public EntitySet getEntitySet(FullQualifiedName entityContainer, String entitySetName) throws ODataException {
        return this.containerProvider.getEntitySet(entityContainer, entitySetName);
    }

    public Singleton getSingleton(FullQualifiedName entityContainer, String singletonName) throws ODataException {
        return this.containerProvider.getSingleton(entityContainer, singletonName);
    }

    public ActionImport getActionImport(FullQualifiedName entityContainer, String actionImportName) throws ODataException {
        return this.containerProvider.getActionImport(entityContainer, actionImportName);
    }

    public FunctionImport getFunctionImport(FullQualifiedName entityContainer, String functionImportName) throws ODataException {
        return this.containerProvider.getFunctionImport(entityContainer, functionImportName);
    }

    public List<Schema> getSchemas() throws ODataException {
        return this.schemaProvider.getSchemas();
    }

    public EntityContainer getEntityContainer() throws ODataException {
        return this.containerProvider.getEntityContainer();
    }

    public EntityContainerInfo getEntityContainerInfo(FullQualifiedName entityContainerName) throws ODataException {
        return this.containerProvider.getEntityContainerInfo(entityContainerName);
    }
}

