/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAProcessor;

public abstract class ODataJPADefaultProcessor
extends ODataJPAProcessor {
    public ODataJPADefaultProcessor(ODataJPAContext oDataJPAContext) {
        super(oDataJPAContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse readEntitySet(GetEntitySetUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> jpaEntities = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntities, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse readEntity(GetEntityUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse countEntitySet(GetEntitySetCountUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            long jpaEntityCount = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(jpaEntityCount);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse existsEntity(GetEntityCountUriInfo uriInfo, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            long jpaEntityCount = this.jpaProcessor.process(uriInfo);
            oDataResponse = this.responseBuilder.build(jpaEntityCount);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse createEntity(PostUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object createdJpaEntity = this.jpaProcessor.process(uriParserResultView, content, requestContentType);
            oDataResponse = this.responseBuilder.build(uriParserResultView, createdJpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse updateEntity(PutMergePatchUriInfo uriParserResultView, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView, content, requestContentType);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse deleteEntity(DeleteUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object deletedObj = this.jpaProcessor.process(uriParserResultView, contentType);
            oDataResponse = this.responseBuilder.build(uriParserResultView, deletedObj);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse executeFunctionImport(GetFunctionImportUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> resultEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, resultEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse executeFunctionImportValue(GetFunctionImportUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> result = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, result.get(0));
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse readEntityLink(GetEntityLinkUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            Object jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse readEntityLinks(GetEntitySetLinksUriInfo uriParserResultView, String contentType) throws ODataException {
        ODataResponse oDataResponse = null;
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            List<Object> jpaEntity = this.jpaProcessor.process(uriParserResultView);
            oDataResponse = this.responseBuilder.build(uriParserResultView, jpaEntity, contentType);
        }
        finally {
            this.close();
        }
        return oDataResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse createEntityLink(PostUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, content, requestContentType, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse updateEntityLink(PutMergePatchUriInfo uriParserResultView, InputStream content, String requestContentType, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, content, requestContentType, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse deleteEntityLink(DeleteUriInfo uriParserResultView, String contentType) throws ODataException {
        try {
            this.oDataJPAContext.setODataContext(this.getContext());
            this.jpaProcessor.process(uriParserResultView, contentType);
            ODataResponse oDataResponse = ODataResponse.newBuilder().build();
            return oDataResponse;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataResponse executeBatch(BatchHandler handler, String contentType, InputStream content) throws ODataException {
        try {
            ODataResponse batchResponse;
            this.oDataJPAContext.setODataContext(this.getContext());
            ArrayList<BatchResponsePart> batchResponseParts = new ArrayList<BatchResponsePart>();
            PathInfo pathInfo = this.getContext().getPathInfo();
            EntityProviderBatchProperties batchProperties = EntityProviderBatchProperties.init().pathInfo(pathInfo).build();
            List batchParts = EntityProvider.parseBatchRequest((String)contentType, (InputStream)content, (EntityProviderBatchProperties)batchProperties);
            for (BatchRequestPart batchPart : batchParts) {
                batchResponseParts.add(handler.handleBatchPart(batchPart));
            }
            ODataResponse oDataResponse = batchResponse = EntityProvider.writeBatchResponse(batchResponseParts);
            return oDataResponse;
        }
        finally {
            this.close(true);
        }
    }

    public BatchResponsePart executeChangeSet(BatchHandler handler, List<ODataRequest> requests) throws ODataException {
        ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
        try {
            this.oDataJPAContext.getODataJPATransaction().begin();
            for (ODataRequest request : requests) {
                this.oDataJPAContext.setODataContext(this.getContext());
                ODataResponse response = handler.handleRequest(request);
                if (response.getStatus().getStatusCode() >= HttpStatusCodes.BAD_REQUEST.getStatusCode()) {
                    this.oDataJPAContext.getODataJPATransaction().rollback();
                    ArrayList<ODataResponse> errorResponses = new ArrayList<ODataResponse>(1);
                    errorResponses.add(response);
                    BatchResponsePart batchResponsePart = BatchResponsePart.responses(errorResponses).changeSet(false).build();
                    return batchResponsePart;
                }
                responses.add(response);
            }
            this.oDataJPAContext.getODataJPATransaction().commit();
            BatchResponsePart batchResponsePart = BatchResponsePart.responses(responses).changeSet(true).build();
            return batchResponsePart;
        }
        catch (Exception e) {
            throw new ODataException("Error on processing request content:" + e.getMessage(), (Throwable)e);
        }
        finally {
            this.close(true);
        }
    }
}

