/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.onami.persist.Preconditions;

class AggregatedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Throwable[] causes;
    private final int numCauses;

    private AggregatedException(String message, Throwable[] causes) {
        super(message);
        this.causes = causes;
        this.numCauses = this.causes.length;
    }

    public Throwable[] getCauses() {
        return (Throwable[])this.causes.clone();
    }

    public int getNumCauses() {
        return this.numCauses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            StackTraceElement[] trace;
            s.println(this);
            for (StackTraceElement aTrace : trace = this.getStackTrace()) {
                s.println("\tat " + aTrace);
            }
            for (int i = 0; i < this.numCauses; ++i) {
                s.println("Cause " + (i + 1) + ":");
                this.causes[i].printStackTrace(s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            StackTraceElement[] trace;
            s.println(this);
            for (StackTraceElement aTrace : trace = this.getStackTrace()) {
                s.println("\tat " + aTrace);
            }
            for (int i = 0; i < this.numCauses; ++i) {
                s.println("Cause " + (i + 1) + ":");
                this.causes[i].printStackTrace(s);
            }
        }
    }

    public String toString() {
        return super.toString() + " (caused by " + this.numCauses + " causes)";
    }

    static class Builder {
        private List<Throwable> causes = new ArrayList<Throwable>();

        Builder() {
        }

        void add(Throwable cause) {
            this.causes.add(Preconditions.checkNotNull(cause, "cause is mandatory!"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void throwRuntimeExceptionIfHasCauses(String msg) {
            try {
                if (!this.causes.isEmpty()) {
                    throw this.getRuntimeException(msg);
                }
            }
            finally {
                this.causes = null;
            }
        }

        private RuntimeException getRuntimeException(String msg) {
            Throwable cause;
            if (this.causes.size() == 1 && (cause = this.causes.get(0)) instanceof RuntimeException) {
                return (RuntimeException)cause;
            }
            return new AggregatedException(msg, this.causes.toArray(new Throwable[this.causes.size()]));
        }
    }
}

