/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.onami.persist.AggregatedException;
import org.apache.onami.persist.AllPersistenceServices;
import org.apache.onami.persist.AllUnitsOfWork;
import org.apache.onami.persist.PersistenceService;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.UnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class AllPersistenceUnits
implements AllPersistenceServices,
AllUnitsOfWork {
    private final List<PersistenceService> persistenceServices = new ArrayList<PersistenceService>();
    private final List<UnitOfWork> unitsOfWork = new ArrayList<UnitOfWork>();
    private final Set<Key<PersistenceService>> persistenceServiceKeys = new HashSet<Key<PersistenceService>>();
    private final Set<Key<UnitOfWork>> unitOfWorkKeys = new HashSet<Key<UnitOfWork>>();

    AllPersistenceUnits() {
    }

    void add(Key<PersistenceService> psKey, Key<UnitOfWork> uowKey) {
        this.persistenceServiceKeys.add(Preconditions.checkNotNull(psKey, "psKey is mandatory!"));
        this.unitOfWorkKeys.add(Preconditions.checkNotNull(uowKey, "ouwKey is mandatory!"));
    }

    @Inject
    private void init(Injector injector) {
        for (Key<PersistenceService> key : this.persistenceServiceKeys) {
            this.persistenceServices.add((PersistenceService)injector.getInstance(key));
        }
        for (Key key : this.unitOfWorkKeys) {
            this.unitsOfWork.add((UnitOfWork)injector.getInstance(key));
        }
    }

    @Override
    public void startAllStoppedPersistenceServices() {
        AggregatedException.Builder exceptionBuilder = new AggregatedException.Builder();
        for (PersistenceService ps : this.persistenceServices) {
            try {
                if (ps.isRunning()) continue;
                ps.start();
            }
            catch (Exception e) {
                exceptionBuilder.add(e);
            }
        }
        exceptionBuilder.throwRuntimeExceptionIfHasCauses("multiple exception occurred while starting the persistence service");
    }

    @Override
    public void stopAllPersistenceServices() {
        AggregatedException.Builder exceptionBuilder = new AggregatedException.Builder();
        for (PersistenceService ps : this.persistenceServices) {
            try {
                ps.stop();
            }
            catch (Exception e) {
                exceptionBuilder.add(e);
            }
        }
        exceptionBuilder.throwRuntimeExceptionIfHasCauses("multiple exception occurred while stopping the persistence service");
    }

    @Override
    public void beginAllInactiveUnitsOfWork() {
        AggregatedException.Builder exceptionBuilder = new AggregatedException.Builder();
        for (UnitOfWork unitOfWork : this.unitsOfWork) {
            try {
                if (unitOfWork.isActive()) continue;
                unitOfWork.begin();
            }
            catch (Exception e) {
                exceptionBuilder.add(e);
            }
        }
        exceptionBuilder.throwRuntimeExceptionIfHasCauses("multiple exception occurred while starting the unit of work");
    }

    @Override
    public void endAllUnitsOfWork() {
        AggregatedException.Builder exceptionBuilder = new AggregatedException.Builder();
        for (UnitOfWork unitOfWork : this.unitsOfWork) {
            try {
                unitOfWork.end();
            }
            catch (Exception e) {
                exceptionBuilder.add(e);
            }
        }
        exceptionBuilder.throwRuntimeExceptionIfHasCauses("multiple exception occurred while ending the unit of work");
    }
}

