/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import org.apache.onami.persist.EntityManagerFactoryFactory;
import org.apache.onami.persist.EntityManagerFactoryProvider;
import org.apache.onami.persist.PersistenceService;
import org.apache.onami.persist.Preconditions;

@Singleton
class ApplicationManagedEntityManagerFactoryProvider
implements EntityManagerFactoryProvider,
PersistenceService {
    private final EntityManagerFactoryFactory emfFactory;
    private EntityManagerFactory emf;

    @Inject
    ApplicationManagedEntityManagerFactoryProvider(EntityManagerFactoryFactory emfFactory) {
        this.emfFactory = Preconditions.checkNotNull(emfFactory, "emfFactory is mandatory!");
    }

    public EntityManagerFactory get() {
        if (this.isRunning()) {
            return this.emf;
        }
        throw new IllegalStateException("PersistenceService is not running.");
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("PersistenceService is already running.");
        }
        this.emf = this.emfFactory.createApplicationManagedEntityManagerFactory();
    }

    public boolean isRunning() {
        return null != this.emf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isRunning()) {
            try {
                this.emf.close();
            }
            finally {
                this.emf = null;
            }
        }
    }
}

