/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import org.apache.onami.persist.EntityManagerFactorySource;
import org.apache.onami.persist.ForContainerManaged;
import org.apache.onami.persist.JndiLookupHelper;
import org.apache.onami.persist.Preconditions;

@Singleton
class EntityManagerFactorySourceByJndiLookup
implements EntityManagerFactorySource {
    private final String jndiName;
    private final JndiLookupHelper jndiLookupHelper;

    @Inject
    EntityManagerFactorySourceByJndiLookup(@ForContainerManaged String jndiName, JndiLookupHelper jndiLookupHelper) {
        this.jndiName = Preconditions.checkNotNull(jndiName, "jndiName is mandatory!");
        this.jndiLookupHelper = Preconditions.checkNotNull(jndiLookupHelper, "jndiLookupHelper is mandatory!");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.jndiLookupHelper.doJndiLookup(EntityManagerFactory.class, this.jndiName);
    }
}

