/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.onami.persist.EntityManagerFactoryProvider;
import org.apache.onami.persist.EntityManagerProvider;
import org.apache.onami.persist.ForContainerManaged;
import org.apache.onami.persist.Nullable;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.UnitOfWork;

@Singleton
class EntityManagerProviderImpl
implements EntityManagerProvider,
UnitOfWork {
    private final EntityManagerFactoryProvider emfProvider;
    private final Properties properties;
    private final ThreadLocal<EntityManager> entityManagers = new ThreadLocal();

    @Inject
    public EntityManagerProviderImpl(EntityManagerFactoryProvider emfProvider, @Nullable @ForContainerManaged Properties properties) {
        this.emfProvider = Preconditions.checkNotNull(emfProvider, "emfProvider is mandatory!");
        this.properties = properties;
    }

    public EntityManager get() throws IllegalStateException {
        EntityManager entityManager = this.entityManagers.get();
        if (entityManager != null) {
            return entityManager;
        }
        throw new IllegalStateException("UnitOfWork is not running.");
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException("Unit of work has already been started.");
        }
        EntityManager em = this.createEntityManager();
        this.entityManagers.set(em);
    }

    private EntityManager createEntityManager() {
        EntityManagerFactory emf = this.emfProvider.get();
        if (null == this.properties) {
            return emf.createEntityManager();
        }
        return emf.createEntityManager((Map)this.properties);
    }

    public boolean isActive() {
        return this.entityManagers.get() != null;
    }

    public void end() {
        EntityManager em = this.entityManagers.get();
        if (em != null) {
            this.closeAndRemoveEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndRemoveEntityManager(EntityManager em) {
        try {
            em.close();
        }
        finally {
            this.entityManagers.remove();
        }
    }
}

