/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import org.apache.onami.persist.EntityManagerProvider;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.TransactionFacade;
import org.apache.onami.persist.TransactionFacadeFactory;
import org.apache.onami.persist.UserTransactionFacade;

@Singleton
class JtaTransactionFacadeFactory
implements TransactionFacadeFactory {
    private final UserTransactionFacade utFacade;
    private final EntityManagerProvider emProvider;

    @Inject
    public JtaTransactionFacadeFactory(UserTransactionFacade utFacade, EntityManagerProvider emProvider) {
        this.utFacade = Preconditions.checkNotNull(utFacade, "utFacade is mandatory!");
        this.emProvider = Preconditions.checkNotNull(emProvider, "emProvider is mandatory!");
    }

    public TransactionFacade createTransactionFacade() {
        if (this.utFacade.isActive()) {
            return new Inner(this.utFacade, this.emProvider.get());
        }
        return new Outer(this.utFacade, this.emProvider.get());
    }

    private static class Outer
    implements TransactionFacade {
        private final UserTransactionFacade txn;
        private final EntityManager em;

        Outer(UserTransactionFacade txn, EntityManager em) {
            this.txn = Preconditions.checkNotNull(txn, "txn is mandatory!");
            this.em = Preconditions.checkNotNull(em, "em is mandatory!");
        }

        public void begin() {
            this.txn.begin();
            this.em.joinTransaction();
        }

        public void commit() {
            if (this.txn.getRollbackOnly()) {
                this.txn.rollback();
            } else {
                this.txn.commit();
            }
        }

        public void rollback() {
            this.txn.rollback();
        }
    }

    private static class Inner
    implements TransactionFacade {
        private final UserTransactionFacade txn;
        private final EntityManager em;

        Inner(UserTransactionFacade txn, EntityManager em) {
            this.txn = Preconditions.checkNotNull(txn, "txn is mandatory!");
            this.em = Preconditions.checkNotNull(em, "em is mandatory!");
        }

        public void begin() {
            this.em.joinTransaction();
        }

        public void commit() {
        }

        public void rollback() {
            this.txn.setRollbackOnly();
        }
    }
}

