/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.onami.persist.AllPersistenceUnits;
import org.apache.onami.persist.PersistenceFilter;
import org.apache.onami.persist.Preconditions;

class PersistenceFilterImpl
implements PersistenceFilter {
    private final AllPersistenceUnits persistenceUnitsContainer;

    @Inject
    PersistenceFilterImpl(AllPersistenceUnits persistenceUnitsContainer) {
        Preconditions.checkNotNull(persistenceUnitsContainer);
        this.persistenceUnitsContainer = persistenceUnitsContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.persistenceUnitsContainer.beginAllInactiveUnitsOfWork();
            chain.doFilter(request, response);
        }
        finally {
            this.persistenceUnitsContainer.endAllUnitsOfWork();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.persistenceUnitsContainer.startAllStoppedPersistenceServices();
    }

    public void destroy() {
        this.persistenceUnitsContainer.stopAllPersistenceServices();
    }
}

