/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import javax.persistence.EntityManagerFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.onami.persist.AllPersistenceServices;
import org.apache.onami.persist.AllPersistenceUnits;
import org.apache.onami.persist.AllUnitsOfWork;
import org.apache.onami.persist.PersistenceFilter;
import org.apache.onami.persist.PersistenceFilterImpl;
import org.apache.onami.persist.PersistenceUnitModule;
import org.apache.onami.persist.PersistenceUnitModuleConfiguration;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.Transactional;
import org.apache.onami.persist.TxnInterceptor;
import org.apache.onami.persist.UnannotatedPersistenceUnitBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceModule
extends AbstractModule {
    private List<PersistenceUnitModuleConfiguration> configurations;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void configure() {
        if (this.configurations != null) {
            throw new RuntimeException("cannot reenter the configure method");
        }
        try {
            this.configurations = new ArrayList<PersistenceUnitModuleConfiguration>();
            this.configurePersistenceUnits();
        }
        finally {
            this.configurations = null;
        }
    }

    private void configurePersistenceUnits() {
        this.configurePersistence();
        this.bind(PersistenceFilter.class).to(PersistenceFilterImpl.class);
        AllPersistenceUnits allPersistenceUnits = new AllPersistenceUnits();
        this.requestInjection(allPersistenceUnits);
        this.bind(AllPersistenceServices.class).toInstance((Object)allPersistenceUnits);
        this.bind(AllUnitsOfWork.class).toInstance((Object)allPersistenceUnits);
        for (PersistenceUnitModuleConfiguration config : this.configurations) {
            TxnInterceptor txnInterceptor = new TxnInterceptor();
            this.install((Module)new PersistenceUnitModule(config, txnInterceptor, allPersistenceUnits));
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{txnInterceptor});
            this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.any(), new MethodInterceptor[]{txnInterceptor});
        }
    }

    protected abstract void configurePersistence();

    protected UnannotatedPersistenceUnitBuilder bindApplicationManagedPersistenceUnit(String puName) {
        Preconditions.checkNotNull(this.configurations, "calling bindApplicationManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setPuName(puName);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnit(EntityManagerFactory emf) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setEmf(emf);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnitWithJndiName(String jndiName) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setEmfJndiName(jndiName);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnitProvidedBy(Provider<EntityManagerFactory> emfProvider) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setEmfProvider(emfProvider);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnitProvidedBy(Class<? extends Provider<EntityManagerFactory>> emfProviderClass) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setEmfProviderClass(emfProviderClass);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnitProvidedBy(TypeLiteral<? extends Provider<EntityManagerFactory>> emfProviderType) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configurator = this.createAndAddConfiguration();
        configurator.setEmfProviderType(emfProviderType);
        return configurator;
    }

    protected UnannotatedPersistenceUnitBuilder bindContainerManagedPersistenceUnitProvidedBy(Key<? extends Provider<EntityManagerFactory>> emfProviderKey) {
        Preconditions.checkNotNull(this.configurations, "calling bindContainerManagedPersistenceUnit outside of configurePersistence is not supported");
        PersistenceUnitModuleConfiguration configuration = this.createAndAddConfiguration();
        configuration.setEmfProviderKey(emfProviderKey);
        return configuration;
    }

    private PersistenceUnitModuleConfiguration createAndAddConfiguration() {
        PersistenceUnitModuleConfiguration configurator = new PersistenceUnitModuleConfiguration();
        this.configurations.add(configurator);
        return configurator;
    }
}

