/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.util.Providers;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.apache.onami.persist.AllPersistenceUnits;
import org.apache.onami.persist.AnnotationHolder;
import org.apache.onami.persist.ApplicationManagedEntityManagerFactoryProvider;
import org.apache.onami.persist.ContainerManagedEntityManagerFactoryProvider;
import org.apache.onami.persist.EntityManagerFactoryFactory;
import org.apache.onami.persist.EntityManagerFactoryProvider;
import org.apache.onami.persist.EntityManagerFactorySource;
import org.apache.onami.persist.EntityManagerFactorySourceByJndiLookup;
import org.apache.onami.persist.EntityManagerFactorySourceViaProvider;
import org.apache.onami.persist.EntityManagerProvider;
import org.apache.onami.persist.EntityManagerProviderImpl;
import org.apache.onami.persist.ForApplicationManaged;
import org.apache.onami.persist.ForContainerManaged;
import org.apache.onami.persist.JtaTransactionFacadeFactory;
import org.apache.onami.persist.PersistenceService;
import org.apache.onami.persist.PersistenceUnitModuleConfiguration;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.ResourceLocalTransactionFacadeFactory;
import org.apache.onami.persist.TransactionFacadeFactory;
import org.apache.onami.persist.TxnInterceptor;
import org.apache.onami.persist.UnitOfWork;
import org.apache.onami.persist.UserTransactionJndiName;
import org.apache.onami.persist.UserTransactionProviderByJndiLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceUnitModule
extends PrivateModule {
    private final PersistenceUnitModuleConfiguration config;
    private final TxnInterceptor transactionInterceptor;
    private final AllPersistenceUnits allPersistenceUnits;

    PersistenceUnitModule(PersistenceUnitModuleConfiguration configurator, TxnInterceptor transactionInterceptor, AllPersistenceUnits allPersistenceUnits) {
        this.config = Preconditions.checkNotNull(configurator, "config is mandatory!");
        this.transactionInterceptor = Preconditions.checkNotNull(transactionInterceptor, "transactionInterceptor is mandatory!");
        this.allPersistenceUnits = Preconditions.checkNotNull(allPersistenceUnits, "allPersistenceUnits is mandatory!");
    }

    protected void configure() {
        this.bind(AnnotationHolder.class).toInstance((Object)this.config.getAnnotationHolder());
        this.bindPersistenceServiceAndEntityManagerFactoryProviderAndProperties();
        this.bindTransactionFacadeFactory();
        this.bind(EntityManagerProvider.class).to(EntityManagerProviderImpl.class);
        this.bind(UnitOfWork.class).to(EntityManagerProviderImpl.class);
        this.exposePersistenceServiceAndEntityManagerProviderAndUnitOfWork();
        if (this.transactionInterceptor != null) {
            this.requestInjection(this.transactionInterceptor);
        }
        this.allPersistenceUnits.add(this.getPersistenceKey(), this.getUnitOfWorkKey());
    }

    private void exposePersistenceServiceAndEntityManagerProviderAndUnitOfWork() {
        if (this.config.isAnnotated()) {
            this.bindAndExposedAnnotated(PersistenceService.class);
            this.bindAndExposedAnnotated(EntityManagerProvider.class);
            this.bindAndExposedAnnotated(UnitOfWork.class);
        } else {
            this.expose(PersistenceService.class);
            this.expose(EntityManagerProvider.class);
            this.expose(UnitOfWork.class);
        }
    }

    private <T> void bindAndExposedAnnotated(Class<T> type) {
        this.bind(type).annotatedWith(this.config.getAnnotation()).to(Key.get(type));
        this.expose(type).annotatedWith(this.config.getAnnotation());
    }

    private Key<PersistenceService> getPersistenceKey() {
        if (this.config.isAnnotated()) {
            return Key.get(PersistenceService.class, this.config.getAnnotation());
        }
        return Key.get(PersistenceService.class);
    }

    private Key<UnitOfWork> getUnitOfWorkKey() {
        if (this.config.isAnnotated()) {
            return Key.get(UnitOfWork.class, this.config.getAnnotation());
        }
        return Key.get(UnitOfWork.class);
    }

    private void bindPersistenceServiceAndEntityManagerFactoryProviderAndProperties() {
        if (this.config.isApplicationManagedPersistenceUnit()) {
            this.bindApplicationManagedPersistenceServiceAndEntityManagerFactoryProviderAndProperties();
        } else {
            this.bindContainerManagedPersistenceServiceAndEntityManagerFactoryProviderAndProperties();
        }
    }

    private void bindApplicationManagedPersistenceServiceAndEntityManagerFactoryProviderAndProperties() {
        this.bind(PersistenceService.class).to(ApplicationManagedEntityManagerFactoryProvider.class);
        this.bind(EntityManagerFactoryProvider.class).to(ApplicationManagedEntityManagerFactoryProvider.class);
        this.bind(Properties.class).annotatedWith(ForContainerManaged.class).toProvider(Providers.of(null));
        this.bind(Properties.class).annotatedWith(ForApplicationManaged.class).toProvider(Providers.of((Object)this.config.getProperties()));
        this.bind(EntityManagerFactoryFactory.class);
        this.bind(String.class).annotatedWith(ForApplicationManaged.class).toInstance((Object)this.config.getPuName());
    }

    private void bindContainerManagedPersistenceServiceAndEntityManagerFactoryProviderAndProperties() {
        this.bind(PersistenceService.class).to(ContainerManagedEntityManagerFactoryProvider.class);
        this.bind(EntityManagerFactoryProvider.class).to(ContainerManagedEntityManagerFactoryProvider.class);
        this.bind(Properties.class).annotatedWith(ForContainerManaged.class).toProvider(Providers.of((Object)this.config.getProperties()));
        this.bind(Properties.class).annotatedWith(ForApplicationManaged.class).toProvider(Providers.of(null));
        this.bindEntityManagerFactorySource();
    }

    private void bindEntityManagerFactorySource() {
        if (this.config.isEmfProvidedByJndiLookup()) {
            this.bind(EntityManagerFactorySource.class).to(EntityManagerFactorySourceByJndiLookup.class);
            this.bind(String.class).annotatedWith(ForContainerManaged.class).toInstance((Object)this.config.getEmfJndiName());
        } else {
            this.bind(EntityManagerFactorySource.class).to(EntityManagerFactorySourceViaProvider.class);
            this.bindInternalEntityManagerFactoryProvider();
        }
    }

    private void bindInternalEntityManagerFactoryProvider() {
        if (this.config.isEmfProvidedByInstance()) {
            this.bind(EntityManagerFactory.class).annotatedWith(ForContainerManaged.class).toInstance((Object)this.config.getEmf());
        } else if (this.config.isEmfProvidedByProvider()) {
            this.bind(EntityManagerFactory.class).annotatedWith(ForContainerManaged.class).toProvider(Providers.guicify(this.config.getEmfProvider()));
        } else if (this.config.isEmfProvidedByProviderKey()) {
            this.bind(EntityManagerFactory.class).annotatedWith(ForContainerManaged.class).toProvider(this.config.getEmfProviderKey());
        } else {
            throw new RuntimeException("EntityManager is improperly configured");
        }
    }

    private void bindTransactionFacadeFactory() {
        if (this.config.isJta()) {
            this.bindJtaTransactionFacadeFactory();
        } else {
            this.bind(TransactionFacadeFactory.class).to(ResourceLocalTransactionFacadeFactory.class);
        }
    }

    private void bindJtaTransactionFacadeFactory() {
        this.bind(TransactionFacadeFactory.class).to(JtaTransactionFacadeFactory.class);
        this.binInternalUserTransactionProvider();
    }

    private void binInternalUserTransactionProvider() {
        if (this.config.isUserTransactionProvidedByInstance()) {
            this.bind(UserTransaction.class).toInstance((Object)this.config.getUserTransaction());
        } else if (this.config.isUserTransactionProvidedByJndiLookup()) {
            this.bind(UserTransaction.class).toProvider(UserTransactionProviderByJndiLookup.class);
            this.bind(String.class).annotatedWith(UserTransactionJndiName.class).toInstance((Object)this.config.getUtJndiName());
        } else if (this.config.isUserTransactionProvidedByProvider()) {
            this.bind(UserTransaction.class).toProvider(Providers.guicify(this.config.getUtProvider()));
        } else if (this.config.isUserTransactionProvidedByProviderKey()) {
            this.bind(UserTransaction.class).toProvider(this.config.getUtProviderKey());
        } else {
            throw new RuntimeException("UserTransaction is improperly configured");
        }
    }
}

