/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityTransaction;
import org.apache.onami.persist.EntityManagerProvider;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.TransactionFacade;
import org.apache.onami.persist.TransactionFacadeFactory;

@Singleton
class ResourceLocalTransactionFacadeFactory
implements TransactionFacadeFactory {
    private final EntityManagerProvider emProvider;

    @Inject
    ResourceLocalTransactionFacadeFactory(EntityManagerProvider emProvider) {
        this.emProvider = Preconditions.checkNotNull(emProvider, "emProvider is mandatory!");
    }

    public TransactionFacade createTransactionFacade() {
        EntityTransaction txn = this.emProvider.get().getTransaction();
        if (txn.isActive()) {
            return new Inner(txn);
        }
        return new Outer(txn);
    }

    private static class Outer
    implements TransactionFacade {
        private final EntityTransaction txn;

        Outer(EntityTransaction txn) {
            this.txn = Preconditions.checkNotNull(txn, "txn is mandatory!");
        }

        public void begin() {
            this.txn.begin();
        }

        public void commit() {
            if (this.txn.getRollbackOnly()) {
                this.txn.rollback();
            } else {
                this.txn.commit();
            }
        }

        public void rollback() {
            this.txn.rollback();
        }
    }

    private static class Inner
    implements TransactionFacade {
        private final EntityTransaction txn;

        Inner(EntityTransaction txn) {
            this.txn = Preconditions.checkNotNull(txn, "txn is mandatory!");
        }

        public void begin() {
        }

        public void commit() {
        }

        public void rollback() {
            this.txn.setRollbackOnly();
        }
    }
}

