/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.lang.reflect.Method;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.onami.persist.Transactional;

@Singleton
class TransactionalAnnotationReader {
    private static final Transactional DEFAULT_TRANSACTIONAL = DefaultTransactional.class.getAnnotation(Transactional.class);

    TransactionalAnnotationReader() {
    }

    Transactional readAnnotationFrom(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Transactional result = method.getAnnotation(Transactional.class);
        if (null == result) {
            Class<?> targetClass = methodInvocation.getThis().getClass();
            result = targetClass.getAnnotation(Transactional.class);
        }
        if (null == result) {
            result = DEFAULT_TRANSACTIONAL;
        }
        return result;
    }

    @Transactional
    private static class DefaultTransactional {
        private DefaultTransactional() {
        }
    }
}

