/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.onami.persist.TransactionFacade;
import org.apache.onami.persist.TransactionFacadeFactory;
import org.apache.onami.persist.TransactionalAnnotationHelper;
import org.apache.onami.persist.UnitOfWork;

class TxnInterceptor
implements MethodInterceptor {
    private UnitOfWork unitOfWork;
    private TransactionFacadeFactory tfProvider;
    private TransactionalAnnotationHelper txnAnnotationHelper;

    TxnInterceptor() {
    }

    @Inject
    void init(UnitOfWork unitOfWork, TransactionFacadeFactory tfProvider, TransactionalAnnotationHelper txnAnnotationHelper) {
        this.unitOfWork = unitOfWork;
        this.tfProvider = tfProvider;
        this.txnAnnotationHelper = txnAnnotationHelper;
    }

    public final Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (this.persistenceUnitParticipatesInTransactionFor(methodInvocation)) {
            return this.invokeInTransactionAndUnitOfWork(methodInvocation);
        }
        return methodInvocation.proceed();
    }

    private boolean persistenceUnitParticipatesInTransactionFor(MethodInvocation methodInvocation) {
        return this.txnAnnotationHelper.persistenceUnitParticipatesInTransactionFor(methodInvocation);
    }

    private Object invokeInTransactionAndUnitOfWork(MethodInvocation methodInvocation) throws Throwable {
        boolean weStartedTheUnitOfWork;
        boolean bl = weStartedTheUnitOfWork = !this.unitOfWork.isActive();
        if (weStartedTheUnitOfWork) {
            this.unitOfWork.begin();
        }
        Throwable originalException = null;
        try {
            Object object = this.invokeInTransaction(methodInvocation);
            return object;
        }
        catch (Throwable exc) {
            originalException = exc;
            throw exc;
        }
        finally {
            if (weStartedTheUnitOfWork) {
                this.endUnitOfWork(originalException);
            }
        }
    }

    private void endUnitOfWork(Throwable originalException) throws Throwable {
        try {
            this.unitOfWork.end();
        }
        catch (Throwable exc) {
            if (originalException != null) {
                throw originalException;
            }
            throw exc;
        }
    }

    private Object invokeInTransaction(MethodInvocation methodInvocation) throws Throwable {
        TransactionFacade transactionFacade = this.tfProvider.createTransactionFacade();
        transactionFacade.begin();
        Object result = this.invokeAndHandleException(methodInvocation, transactionFacade);
        transactionFacade.commit();
        return result;
    }

    private Object invokeAndHandleException(MethodInvocation methodInvocation, TransactionFacade transactionFacade) throws Throwable {
        try {
            return methodInvocation.proceed();
        }
        catch (Throwable exc) {
            this.handleException(methodInvocation, transactionFacade, exc);
            throw exc;
        }
    }

    private void handleException(MethodInvocation methodInvocation, TransactionFacade transactionFacade, Throwable exc) throws Throwable {
        try {
            if (this.isRollbackNecessaryFor(methodInvocation, exc)) {
                transactionFacade.rollback();
            } else {
                transactionFacade.commit();
            }
        }
        catch (Exception swallowedException) {
            throw exc;
        }
    }

    private boolean isRollbackNecessaryFor(MethodInvocation methodInvocation, Throwable exc) {
        return this.txnAnnotationHelper.isRollbackNecessaryFor(methodInvocation, exc);
    }
}

