/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Singleton;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.onami.persist.Preconditions;

@Singleton
class UserTransactionFacade {
    private static final Set<Integer> ROLLBACK_ONLY_STATES = new HashSet<Integer>(Arrays.asList(1, 9, 4));
    private final UserTransaction txn;

    UserTransactionFacade(UserTransaction txn) {
        this.txn = Preconditions.checkNotNull(txn, "txn is mandatory!");
    }

    void begin() {
        try {
            this.txn.begin();
        }
        catch (NotSupportedException e) {
            throw new RuntimeException("nested transactions are not supported by the user transaction " + this.txn, e);
        }
        catch (SystemException e) {
            throw new RuntimeException("unexpected error occurred", e);
        }
    }

    void commit() {
        try {
            this.txn.commit();
        }
        catch (SecurityException e) {
            throw new RuntimeException("not allowed to commit the transaction", e);
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("no transaction associated with userTransaction", e);
        }
        catch (RollbackException e) {
            throw new RuntimeException("rollback during commit", e);
        }
        catch (HeuristicMixedException e) {
            throw new RuntimeException("heuristic partial rollback during commit", e);
        }
        catch (HeuristicRollbackException e) {
            throw new RuntimeException("heuristic rollback during commit", e);
        }
        catch (SystemException e) {
            throw new RuntimeException("unexpected error occurred", e);
        }
    }

    void rollback() {
        try {
            this.txn.rollback();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("no transaction associated with userTransaction", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("not allowed to rollback the transaction", e);
        }
        catch (SystemException e) {
            throw new RuntimeException("unexpected error occurred", e);
        }
    }

    void setRollbackOnly() {
        try {
            this.txn.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw new RuntimeException("no transaction associated with userTransaction", e);
        }
        catch (SystemException e) {
            throw new RuntimeException("unexpected error occurred", e);
        }
    }

    boolean getRollbackOnly() {
        return ROLLBACK_ONLY_STATES.contains(this.getStatus());
    }

    boolean isActive() {
        return this.getStatus() != 6;
    }

    private int getStatus() {
        try {
            int status = this.txn.getStatus();
            for (int i = 0; status == 5 && i < 8; ++i) {
                try {
                    Thread.sleep(30L * (long)i + 30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                status = this.txn.getStatus();
            }
            return status;
        }
        catch (SystemException e) {
            throw new RuntimeException("unexpected error occurred", e);
        }
    }
}

