/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import org.apache.onami.persist.EntityManagerFactoryProvider;
import org.apache.onami.persist.EntityManagerFactorySource;
import org.apache.onami.persist.PersistenceService;
import org.apache.onami.persist.Preconditions;

@Singleton
class ContainerManagedEntityManagerFactoryProvider
implements EntityManagerFactoryProvider,
PersistenceService {
    private final EntityManagerFactorySource emfSource;
    private EntityManagerFactory emf;

    @Inject
    ContainerManagedEntityManagerFactoryProvider(EntityManagerFactorySource emfSource) {
        this.emfSource = Preconditions.checkNotNull(emfSource, "emfSource is mandatory!");
    }

    public EntityManagerFactory get() {
        if (this.isRunning()) {
            return this.emf;
        }
        throw new IllegalStateException("PersistenceService is not running.");
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("PersistenceService is already running.");
        }
        this.emf = this.emfSource.getEntityManagerFactory();
    }

    public boolean isRunning() {
        return null != this.emf;
    }

    public void stop() {
        this.emf = null;
    }
}

