/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.onami.persist.ForApplicationManaged;
import org.apache.onami.persist.Nullable;
import org.apache.onami.persist.Preconditions;

@Singleton
class EntityManagerFactoryFactory {
    private final String puName;
    private final Properties properties;

    @Inject
    EntityManagerFactoryFactory(@ForApplicationManaged String puName, @Nullable @ForApplicationManaged Properties properties) {
        this.puName = Preconditions.checkNotNull(puName, "puName is mandatory!");
        this.properties = properties;
    }

    EntityManagerFactory createApplicationManagedEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.puName, (Map)this.properties);
    }
}

