/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.onami.persist.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class JndiLookupHelper {
    JndiLookupHelper() {
    }

    <T> T doJndiLookup(Class<T> type, String jndiName) {
        try {
            InitialContext ctx = new InitialContext();
            Object result = ctx.lookup(jndiName);
            Preconditions.checkNotNull(result, "lookup for " + type.getSimpleName() + " with JNDI name '" + jndiName + "' returned null");
            return (T)result;
        }
        catch (NamingException e) {
            throw new RuntimeException("lookup for " + type.getSimpleName() + " with JNDI name '" + jndiName + "' failed", e);
        }
    }
}

