/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.onami.persist.AllPersistenceServices;
import org.apache.onami.persist.AllUnitsOfWork;
import org.apache.onami.persist.PersistenceFilter;
import org.apache.onami.persist.Preconditions;

class PersistenceFilterImpl
implements PersistenceFilter {
    private final AllPersistenceServices allPersistenceServices;
    private final AllUnitsOfWork allUnitsOfWork;

    @Inject
    PersistenceFilterImpl(AllPersistenceServices allPersistenceServices, AllUnitsOfWork allUnitsOfWork) {
        this.allPersistenceServices = Preconditions.checkNotNull(allPersistenceServices, "allPersistenceServices is mandatory!");
        this.allUnitsOfWork = Preconditions.checkNotNull(allUnitsOfWork, "allUnitsOfWork is mandatory!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.allUnitsOfWork.beginAllInactiveUnitsOfWork();
            chain.doFilter(request, response);
        }
        finally {
            this.allUnitsOfWork.endAllUnitsOfWork();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.allPersistenceServices.startAllStoppedPersistenceServices();
    }

    public void destroy() {
        this.allPersistenceServices.stopAllPersistenceServices();
    }
}

