/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.inject.Provider;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.apache.onami.persist.AnnotatedPersistenceUnitBuilder;
import org.apache.onami.persist.AnnotationHolder;
import org.apache.onami.persist.UnannotatedPersistenceUnitBuilder;
import org.apache.onami.persist.UnconfiguredPersistenceUnitBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistenceUnitModuleConfiguration
implements UnannotatedPersistenceUnitBuilder,
AnnotatedPersistenceUnitBuilder,
UnconfiguredPersistenceUnitBuilder {
    private Class<? extends Annotation> annotation;
    private boolean isJta = false;
    private UserTransaction userTransaction;
    private String utJndiName;
    private Provider<UserTransaction> utProvider;
    private Key<? extends Provider<UserTransaction>> utProviderKey;
    private Properties properties;
    private String puName;
    private EntityManagerFactory emf;
    private String emfJndiName;
    private Provider<EntityManagerFactory> emfProvider;
    private Key<? extends Provider<EntityManagerFactory>> emfProviderKey;

    PersistenceUnitModuleConfiguration() {
    }

    @Override
    public AnnotatedPersistenceUnitBuilder annotatedWith(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        return this;
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useLocalTransaction() {
        this.isJta = false;
        return this;
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransaction(UserTransaction userTransaction) {
        this.isJta = true;
        this.userTransaction = userTransaction;
        return this;
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransactionWithJndiName(String utJndiName) {
        this.isJta = true;
        this.utJndiName = utJndiName;
        return this;
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransactionProvidedBy(Provider<UserTransaction> utProvider) {
        this.isJta = true;
        this.utProvider = utProvider;
        return this;
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransactionProvidedBy(Class<? extends Provider<UserTransaction>> utProviderClass) {
        return this.useGlobalTransactionProvidedBy((Key<? extends Provider<UserTransaction>>)Key.get(utProviderClass));
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransactionProvidedBy(TypeLiteral<? extends Provider<UserTransaction>> utProviderType) {
        return this.useGlobalTransactionProvidedBy((Key<? extends Provider<UserTransaction>>)Key.get(utProviderType));
    }

    @Override
    public UnconfiguredPersistenceUnitBuilder useGlobalTransactionProvidedBy(Key<? extends Provider<UserTransaction>> utProviderKey) {
        this.isJta = true;
        this.utProviderKey = utProviderKey;
        return this;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    void setPuName(String puName) {
        this.puName = puName;
    }

    void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    void setEmfJndiName(String emfJndiName) {
        this.emfJndiName = emfJndiName;
    }

    void setEmfProvider(Provider<EntityManagerFactory> emfProvider) {
        this.emfProvider = emfProvider;
    }

    void setEmfProviderClass(Class<? extends Provider<EntityManagerFactory>> emfProviderClass) {
        this.emfProviderKey = Key.get(emfProviderClass);
    }

    void setEmfProviderType(TypeLiteral<? extends Provider<EntityManagerFactory>> emfProviderType) {
        this.emfProviderKey = Key.get(emfProviderType);
    }

    void setEmfProviderKey(Key<? extends Provider<EntityManagerFactory>> emfProviderKey) {
        this.emfProviderKey = emfProviderKey;
    }

    boolean isApplicationManagedPersistenceUnit() {
        return this.puName != null;
    }

    UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    String getUtJndiName() {
        return this.utJndiName;
    }

    Provider<UserTransaction> getUtProvider() {
        return this.utProvider;
    }

    Key<? extends Provider<UserTransaction>> getUtProviderKey() {
        return this.utProviderKey;
    }

    Properties getProperties() {
        return this.properties;
    }

    String getPuName() {
        return this.puName;
    }

    EntityManagerFactory getEmf() {
        return this.emf;
    }

    String getEmfJndiName() {
        return this.emfJndiName;
    }

    Provider<EntityManagerFactory> getEmfProvider() {
        return this.emfProvider;
    }

    Key<? extends Provider<EntityManagerFactory>> getEmfProviderKey() {
        return this.emfProviderKey;
    }

    boolean isEmfProvidedByJndiLookup() {
        return this.emfJndiName != null;
    }

    boolean isEmfProvidedByInstance() {
        return this.emf != null;
    }

    boolean isEmfProvidedByProvider() {
        return this.emfProvider != null;
    }

    boolean isEmfProvidedByProviderKey() {
        return this.emfProviderKey != null;
    }

    boolean isJta() {
        return this.isJta;
    }

    boolean isUserTransactionProvidedByJndiLookup() {
        return this.utJndiName != null;
    }

    boolean isUserTransactionProvidedByInstance() {
        return this.userTransaction != null;
    }

    boolean isUserTransactionProvidedByProvider() {
        return this.utProvider != null;
    }

    boolean isUserTransactionProvidedByProviderKey() {
        return this.utProviderKey != null;
    }

    boolean isAnnotated() {
        return this.annotation != null;
    }

    AnnotationHolder getAnnotationHolder() {
        return new AnnotationHolder(this.annotation);
    }

    Class<? extends Annotation> getAnnotation() {
        return this.annotation;
    }
}

