/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.onami.persist.AnnotationHolder;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.Transactional;
import org.apache.onami.persist.TransactionalAnnotationReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class TransactionalAnnotationHelper {
    private final Class<? extends Annotation> puAnnotation;
    private final TransactionalAnnotationReader txnAnnoReader;

    @Inject
    TransactionalAnnotationHelper(AnnotationHolder annotationHolder, TransactionalAnnotationReader txnAnnoReader) {
        this.puAnnotation = annotationHolder.getAnnotation();
        this.txnAnnoReader = Preconditions.checkNotNull(txnAnnoReader, "txnAnnoReader is mandatory!");
    }

    boolean persistenceUnitParticipatesInTransactionFor(MethodInvocation methodInvocation) {
        return this.puAnnotation == null || this.participates(methodInvocation);
    }

    private boolean participates(MethodInvocation methodInvocation) {
        Transactional transactional = this.txnAnnoReader.readAnnotationFrom(methodInvocation);
        Object[] onUnits = transactional.onUnits();
        return this.isEmpty(onUnits) || this.contains(onUnits, this.puAnnotation);
    }

    private boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private boolean contains(Object[] array, Object key) {
        return Arrays.asList(array).contains(key);
    }

    boolean isRollbackNecessaryFor(MethodInvocation methodInvocation, Throwable exc) {
        Transactional transactional = this.txnAnnoReader.readAnnotationFrom(methodInvocation);
        return this.isRollbackNecessaryFor(transactional, exc);
    }

    private boolean isRollbackNecessaryFor(Transactional transactional, Throwable exc) {
        return this.containsSuper(transactional.rollbackOn(), exc) && !this.containsSuper(transactional.ignore(), exc);
    }

    private boolean containsSuper(Class<? extends Exception>[] classes, Throwable exc) {
        for (Class<? extends Exception> c : classes) {
            if (!c.isInstance(exc)) continue;
            return true;
        }
        return false;
    }
}

