/*
 * Decompiled with CFR 0.152.
 */
package org.apache.onami.persist;

import javax.inject.Provider;
import javax.inject.Singleton;
import javax.transaction.UserTransaction;
import org.apache.onami.persist.JndiLookupHelper;
import org.apache.onami.persist.Preconditions;
import org.apache.onami.persist.UserTransactionJndiName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class UserTransactionProviderByJndiLookup
implements Provider<UserTransaction> {
    private final String jndiName;
    private final JndiLookupHelper jndiLookupHelper;

    UserTransactionProviderByJndiLookup(@UserTransactionJndiName String jndiName, JndiLookupHelper jndiLookupHelper) {
        this.jndiName = Preconditions.checkNotNull(jndiName, "jndiName is mandatory!");
        this.jndiLookupHelper = Preconditions.checkNotNull(jndiLookupHelper, "jndiLookupHelper is mandatory!");
    }

    public UserTransaction get() {
        return this.jndiLookupHelper.doJndiLookup(UserTransaction.class, this.jndiName);
    }
}

