/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.MetExtractor;
import org.apache.oodt.cas.metadata.MetExtractorConfig;
import org.apache.oodt.cas.metadata.MetExtractorConfigReader;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;

public abstract class AbstractMetExtractor
implements MetExtractor {
    protected MetExtractorConfig config;
    protected MetExtractorConfigReader reader;
    protected static final Logger LOG = Logger.getLogger(AbstractMetExtractor.class.getName());

    public AbstractMetExtractor(MetExtractorConfigReader reader) {
        this.reader = reader;
    }

    protected abstract Metadata extrMetadata(File var1) throws MetExtractionException;

    public Metadata extractMetadata(File f) throws MetExtractionException {
        if (f == null || !f.exists()) {
            throw new MetExtractionException("File '" + f + "' does not exist");
        }
        return this.extrMetadata(this.safeGetCanonicalFile(f));
    }

    public Metadata extractMetadata(String filePath) throws MetExtractionException {
        return this.extractMetadata(new File(filePath));
    }

    public Metadata extractMetadata(URL fileUrl) throws MetExtractionException {
        try {
            return this.extractMetadata(this.safeGetFileFromUri(fileUrl));
        }
        catch (Exception e) {
            throw new MetExtractionException("Failed to extract metadata from URL '" + fileUrl + "' : " + e.getMessage());
        }
    }

    public Metadata extractMetadata(File f, File configFile) throws MetExtractionException {
        this.setConfigFile(configFile);
        return this.extractMetadata(f);
    }

    public Metadata extractMetadata(File f, String configFilePath) throws MetExtractionException {
        return this.extractMetadata(f, new File(configFilePath));
    }

    public Metadata extractMetadata(File f, MetExtractorConfig config) throws MetExtractionException {
        this.setConfigFile(config);
        return this.extractMetadata(f);
    }

    public Metadata extractMetadata(URL fileUrl, MetExtractorConfig config) throws MetExtractionException {
        this.setConfigFile(config);
        return this.extractMetadata(fileUrl);
    }

    public void setConfigFile(File f) throws MetExtractionException {
        try {
            this.setConfigFile(this.reader.parseConfigFile(this.safeGetCanonicalFile(f)));
        }
        catch (Exception e) {
            throw new MetExtractionException("Failed to parse config file : " + e.getMessage());
        }
    }

    public void setConfigFile(MetExtractorConfig config) {
        this.config = config;
    }

    public void setConfigFile(String filePath) throws MetExtractionException {
        this.setConfigFile(new File(filePath));
    }

    private File safeGetFileFromUri(URL url) {
        try {
            return new File(new URI(url.toExternalForm()));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception constructing file from uri: [" + url + "]: Message: " + e.getMessage());
            return null;
        }
    }

    private File safeGetCanonicalFile(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception get canonical file for file : [" + f + "]: Message: " + e.getMessage());
            return null;
        }
    }
}

