/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.SerializableMetadata;
import org.apache.oodt.cas.metadata.exceptions.MetExtractionException;
import org.apache.oodt.cas.metadata.extractors.CmdLineMetExtractor;
import org.apache.oodt.cas.metadata.extractors.ExternConfigReader;
import org.apache.oodt.cas.metadata.extractors.ExternMetExtractorMetKeys;
import org.apache.oodt.cas.metadata.extractors.ExternalMetExtractorConfig;
import org.apache.oodt.commons.exec.ExecUtils;

public class ExternMetExtractor
extends CmdLineMetExtractor
implements ExternMetExtractorMetKeys {
    private static ExternConfigReader reader = new ExternConfigReader();

    public ExternMetExtractor() throws InstantiationException {
        super(reader);
    }

    public Metadata extrMetadata(File file) throws MetExtractionException {
        String workingDirPath = ((ExternalMetExtractorConfig)this.config).getWorkingDirPath();
        if (workingDirPath == null || workingDirPath.equals("")) {
            workingDirPath = file.getParentFile().getAbsolutePath();
        }
        File workingDir = new File(workingDirPath);
        String metFileName = file.getName() + "." + ((ExternalMetExtractorConfig)this.config).getMetFileExt();
        String metFilePath = workingDir.getAbsolutePath() + "/" + metFileName;
        File metFile = new File(metFilePath);
        Vector<String> commandLineList = new Vector<String>();
        commandLineList.add(((ExternalMetExtractorConfig)this.config).getExtractorBinPath());
        if (((ExternalMetExtractorConfig)this.config).getArgList() != null && ((ExternalMetExtractorConfig)this.config).getArgList().length > 0) {
            commandLineList.addAll(Arrays.asList(((ExternalMetExtractorConfig)this.config).getArgList()));
        }
        String[] commandLineArgs = new String[commandLineList.size()];
        for (int i = 0; i < commandLineList.size(); ++i) {
            commandLineArgs[i] = StringUtils.replace((String)StringUtils.replace((String)((String)commandLineList.get(i)), (String)"<MET_FILE_PLACE_HOLDER>", (String)metFilePath), (String)"<DATA_FILE_PLACE_HOLDER>", (String)file.getAbsolutePath());
        }
        LOG.log(Level.INFO, "Generating met file for product file: [" + file.getAbsolutePath() + "]");
        int status = -1;
        try {
            LOG.log(Level.INFO, "Executing command line: [" + ExecUtils.printCommandLine((String[])commandLineArgs) + "] with workingDir: [" + workingDir + "] to extract metadata");
            status = ExecUtils.callProgram((String[])commandLineArgs, (File)workingDir);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "IOException running met extraction: commandLine: [" + ExecUtils.printCommandLine((String[])commandLineArgs) + "]: Message: " + e.getMessage());
            return null;
        }
        if (status != 0) {
            throw new MetExtractionException("Exit status for met extraction not 0");
        }
        if (!metFile.exists()) {
            throw new MetExtractionException("Met extractor failed to create metadata file");
        }
        LOG.log(Level.INFO, "Met extraction successful for product file: [" + file.getAbsolutePath() + "]");
        try {
            SerializableMetadata sm = new SerializableMetadata("UTF-8", false);
            sm.loadMetadataFromXmlStream(new FileInputStream(metFile));
            return sm;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetExtractionException(e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        ExternMetExtractor.processMain(args, new ExternMetExtractor());
    }
}

