/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.preconditions;

import java.io.File;
import java.io.FileInputStream;
import org.apache.oodt.cas.metadata.exceptions.PreconditionComparatorException;
import org.apache.oodt.cas.metadata.preconditions.PreConditionComparator;
import org.apache.oodt.cas.metadata.util.MimeTypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTypeComparator
extends PreConditionComparator<String> {
    private boolean useMagic = false;
    private MimeTypeUtils mimeTypeUtils = new MimeTypeUtils();

    @Override
    protected int performCheck(File product, String mimeType) throws PreconditionComparatorException {
        try {
            String tikaMimeType = this.mimeTypeUtils.getMimeType(product);
            if (tikaMimeType == null && this.useMagic) {
                tikaMimeType = this.mimeTypeUtils.getMimeTypeByMagic(MimeTypeUtils.readMagicHeader(new FileInputStream(product)));
            }
            return tikaMimeType.compareTo(mimeType);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new PreconditionComparatorException("Failed to get mime-type for " + product + " : " + e.getMessage());
        }
    }

    public void setMimeTypeRepo(String mimeTypeRepo) {
        try {
            this.mimeTypeUtils = new MimeTypeUtils(mimeTypeRepo);
        }
        catch (Exception e) {
            this.mimeTypeUtils = new MimeTypeUtils();
        }
    }

    public void setUseMagic(boolean useMagic) {
        this.useMagic = useMagic;
    }
}

