/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.oodt.cas.metadata.MetExtractorConfig;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.util.PathUtils;
import org.apache.oodt.pcs.input.PGEConfigFileException;
import org.apache.oodt.pcs.input.PGEConfigFileReader;
import org.apache.oodt.pcs.input.PGEConfigurationFile;
import org.apache.oodt.pcs.input.PGEGroup;
import org.apache.oodt.pcs.input.PGEScalar;
import org.apache.oodt.pcs.input.PGEVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilenameTokenConfig
implements MetExtractorConfig {
    private PGEConfigurationFile conf;

    public FilenameTokenConfig() {
        this.conf = null;
    }

    public FilenameTokenConfig(PGEConfigurationFile conf) {
        this.conf = conf;
    }

    public void setConfig(String confFilePath) throws FileNotFoundException, PGEConfigFileException {
        this.conf = new PGEConfigFileReader().read((InputStream)new FileInputStream(new File(confFilePath)));
    }

    public SimpleDateFormat getDateFormatter() {
        return new SimpleDateFormat(((PGEGroup)this.conf.getPgeSpecificGroups().get("ProductionDateTimeGroup")).getScalar("DateTimeFormat").getValue());
    }

    public boolean hasTokenNameList() {
        return this.conf.getPgeSpecificGroups().get("TokenNameListGroup") != null;
    }

    public String getTokenDelimeterScalar() {
        return ((PGEGroup)this.conf.getPgeSpecificGroups().get("TokenNameListGroup")).getScalar("Delimeter").getValue();
    }

    public List<String> getTokenMetKeyNames() {
        return ((PGEGroup)this.conf.getPgeSpecificGroups().get("TokenNameListGroup")).getVector("TokenMetKeys").getElements();
    }

    public Metadata getSubstringOffsetMet(File file) {
        PGEGroup substrOffsetGroup = (PGEGroup)this.conf.getPgeSpecificGroups().get("SubstringOffsetGroup");
        Metadata met = new Metadata();
        if (substrOffsetGroup == null) {
            return met;
        }
        String filename = file.getName();
        for (PGEVector vec : substrOffsetGroup.getVectors().values()) {
            String metKeyName = vec.getName();
            int offset = Integer.valueOf((String)vec.getElements().get(0)) - 1;
            int length = Integer.valueOf((String)vec.getElements().get(1));
            String metVal = filename.substring(offset, offset + length).trim();
            met.addMetadata(metKeyName, metVal);
        }
        return met;
    }

    public Metadata getCommonMet() {
        PGEGroup commonMetGroup = (PGEGroup)this.conf.getPgeSpecificGroups().get("CommonMetadata");
        Metadata met = new Metadata();
        for (String scalarName : commonMetGroup.getScalars().keySet()) {
            PGEScalar scalar = commonMetGroup.getScalar(scalarName);
            met.addMetadata(scalar.getName(), PathUtils.replaceEnvVariables(scalar.getValue()));
        }
        for (String vecName : commonMetGroup.getVectors().keySet()) {
            PGEVector vec = commonMetGroup.getVector(vecName);
            for (String val : vec.getElements()) {
                met.addMetadata(vecName, PathUtils.replaceEnvVariables(val));
            }
        }
        return met;
    }

    public PGEConfigurationFile getConf() {
        return this.conf;
    }

    public void setConf(PGEConfigurationFile conf) {
        this.conf = conf;
    }
}

