/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.extractors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.oodt.cas.metadata.AbstractMetExtractor;
import org.apache.oodt.cas.metadata.MetExtractorConfigReader;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.cas.metadata.SerializableMetadata;
import org.apache.oodt.commons.exec.EnvUtilities;
import org.apache.oodt.commons.xml.XMLUtils;
import org.w3c.dom.Document;

public abstract class CmdLineMetExtractor
extends AbstractMetExtractor {
    public CmdLineMetExtractor(MetExtractorConfigReader reader) {
        super(reader);
    }

    protected static void processMain(String[] args, CmdLineMetExtractor extractor) throws Exception {
        String usage = "Usage: " + extractor.getClass().getName() + " <file> <configfile>";
        String extractFilePath = null;
        String configFilePath = null;
        if (args.length < 2) {
            System.err.println(usage);
            System.exit(1);
        }
        extractFilePath = args[0].replaceAll("\\\\", "");
        configFilePath = args[1];
        Metadata met = extractor.extractMetadata(new File(extractFilePath), configFilePath);
        XMLUtils.writeXmlToStream((Document)new SerializableMetadata(met).toXML(), (OutputStream)CmdLineMetExtractor.getMetFileOutputStream(extractFilePath));
    }

    protected static void processMain(String[] args, CmdLineMetExtractor extractor, OutputStream os) throws Exception {
        String usage = "Usage: " + extractor.getClass().getName() + " <file> <configfile>";
        String extractFilePath = null;
        String configFilePath = null;
        if (args.length < 2) {
            System.err.println(usage);
            System.exit(1);
        }
        extractFilePath = args[0].replaceAll("\\\\", "");
        configFilePath = args[1];
        Metadata met = extractor.extractMetadata(new File(extractFilePath), configFilePath);
        XMLUtils.writeXmlToStream((Document)new SerializableMetadata(met).toXML(), (OutputStream)os);
    }

    private static FileOutputStream getMetFileOutputStream(String filePath) {
        String metFilePath;
        File metFile;
        Properties envVars = EnvUtilities.getEnv();
        String cwd = envVars.getProperty("PWD");
        if (cwd == null) {
            throw new RuntimeException("Unable to get current working directory: failing!");
        }
        if (!cwd.endsWith("/")) {
            cwd = cwd + "/";
        }
        if (!(metFile = new File(metFilePath = cwd + new File(filePath).getName().replaceAll("\\\\", "") + ".met")).delete()) {
            LOG.log(Level.WARNING, "Attempt to overwrite met file: [" + metFilePath + "] unsuccessful!");
        }
        try {
            return new FileOutputStream(metFile);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "Could not create met file: [" + metFile + "]: Reason " + e.getMessage(), e);
            return null;
        }
    }
}

