/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.preconditions;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.oodt.cas.metadata.exceptions.PreconditionComparatorException;
import org.apache.oodt.cas.metadata.preconditions.ExistanceCheckComparator;

public class SubProductExistenceCheckComparator
extends ExistanceCheckComparator {
    private static final Logger LOG = Logger.getLogger(ExistanceCheckComparator.class.getName());
    private String filePath;

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    protected int performCheck(File product, Boolean compareItem) throws PreconditionComparatorException {
        if (product.isDirectory() && this.filePath != null) {
            File file = new File(product.getAbsolutePath() + "/" + this.filePath);
            LOG.log(Level.INFO, "Checking existence of file=" + file.getAbsolutePath());
            return new Boolean(file.exists()).compareTo(compareItem);
        }
        return new Boolean(product.exists()).compareTo(compareItem);
    }
}

