/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.commons.date.DateUtils;
import org.apache.oodt.commons.exec.EnvUtilities;

public final class PathUtils {
    public static String DELIMITER = ",";

    public static String replaceEnvVariables(String origPath) {
        return PathUtils.replaceEnvVariables(origPath, null);
    }

    public static String replaceEnvVariables(String origPath, Metadata metadata) {
        return PathUtils.replaceEnvVariables(origPath, metadata, false);
    }

    public static String replaceEnvVariables(String origPath, Metadata metadata, boolean expand) {
        StringBuffer finalPath = new StringBuffer();
        for (int i = 0; i < origPath.length(); ++i) {
            if (origPath.charAt(i) == '[') {
                VarData data = PathUtils.readEnvVarName(origPath, i);
                String var = null;
                if (metadata != null && metadata.getMetadata(data.getFieldName()) != null) {
                    List<String> valList = metadata.getAllMetadata(data.getFieldName());
                    var = valList.get(0);
                    if (expand) {
                        for (int j = 1; j < valList.size(); ++j) {
                            var = var + DELIMITER + valList.get(j);
                        }
                    }
                } else {
                    var = EnvUtilities.getEnv((String)data.getFieldName());
                }
                finalPath.append(var);
                i = data.getEndIdx();
                continue;
            }
            finalPath.append(origPath.charAt(i));
        }
        return finalPath.toString();
    }

    public static String doDynamicReplacement(String string) throws Exception {
        return PathUtils.doDynamicReplacement(string, null);
    }

    public static String doDynamicReplacement(String string, Metadata metadata) throws Exception {
        return PathUtils.replaceEnvVariables(PathUtils.doDynamicDateReplacement(PathUtils.doDynamicDateRollReplacement(PathUtils.doDynamicDateFormatReplacement(PathUtils.doDynamicUtcToTaiDateReplacement(PathUtils.doDynamicDateToSecsReplacement(PathUtils.doDynamicDateToMillisReplacement(string, metadata), metadata), metadata), metadata), metadata), metadata), metadata, true);
    }

    public static String doDynamicDateReplacement(String string, Metadata metadata) throws Exception {
        Pattern datePattern = Pattern.compile("\\[\\s*DATE\\s*(?:[+-]{1}[^\\.]{1,}?){0,1}\\.\\s*(?:(?:DAY)|(?:MONTH)|(?:YEAR)|(?:UTC)|(?:TAI)){1}\\s*\\]");
        Matcher dateMatcher = datePattern.matcher(string);
        while (dateMatcher.find()) {
            String[] splitDate;
            String dateString = string.substring(dateMatcher.start(), dateMatcher.end());
            GregorianCalendar gc = new GregorianCalendar();
            int plusMinusIndex = dateString.indexOf(45);
            if (plusMinusIndex != -1 || (plusMinusIndex = dateString.indexOf(43)) != -1) {
                int dotIndex = dateString.indexOf(46, plusMinusIndex);
                if (dotIndex != -1) {
                    int rollDays = Integer.parseInt(PathUtils.replaceEnvVariables(dateString.substring(plusMinusIndex, dotIndex), metadata).replaceAll("[\\+\\s]", ""));
                    gc.add(6, rollDays);
                } else {
                    throw new Exception("Malformed dynamic date replacement specified (no dot separator) - '" + dateString + "'");
                }
            }
            if ((splitDate = dateString.split("\\.")).length < 2) {
                throw new Exception("No date type specified - '" + dateString + "'");
            }
            String dateType = splitDate[1].replaceAll("[\\[\\]\\s]", "");
            String replacement = "";
            if (dateType.equals("DAY")) {
                replacement = StringUtils.leftPad((String)(gc.get(5) + ""), (int)2, (String)"0");
            } else if (dateType.equals("MONTH")) {
                replacement = StringUtils.leftPad((String)(gc.get(2) + 1 + ""), (int)2, (String)"0");
            } else if (dateType.equals("YEAR")) {
                replacement = gc.get(1) + "";
            } else if (dateType.equals("UTC")) {
                replacement = DateUtils.toString((Calendar)DateUtils.toUtc((Calendar)gc));
            } else if (dateType.equals("TAI")) {
                replacement = DateUtils.toString((Calendar)DateUtils.toTai((Calendar)gc));
            } else {
                throw new Exception("Invalid date type specified '" + dateString + "'");
            }
            string = StringUtils.replace((String)string, (String)dateString, (String)replacement);
            dateMatcher = datePattern.matcher(string);
        }
        return string;
    }

    public static String doDynamicDateRollReplacement(String string, Metadata metadata) throws Exception {
        Pattern dateFormatPattern = Pattern.compile("\\[\\s*DATE_ADD\\s*\\(.{1,}?,.{1,}?,.{1,}?,.{1,}?\\)\\s*\\]");
        Matcher dateFormatMatcher = dateFormatPattern.matcher(string);
        while (dateFormatMatcher.find()) {
            String dateFormatString = string.substring(dateFormatMatcher.start(), dateFormatMatcher.end());
            Matcher argMatcher = Pattern.compile("\\(.*\\)").matcher(dateFormatString);
            argMatcher.find();
            String argsString = dateFormatString.substring(argMatcher.start() + 1, argMatcher.end() - 1);
            argsString = PathUtils.doDynamicReplacement(argsString, metadata);
            String[] args = argsString.split(",");
            String dateString = args[0].trim();
            dateString = PathUtils.doDynamicReplacement(dateString, metadata);
            String dateFormat = args[1].trim();
            int addAmount = Integer.parseInt(args[2].trim());
            String addUnits = args[3].trim().toLowerCase();
            Date date = new SimpleDateFormat(dateFormat).parse(dateString);
            Calendar calendar = (Calendar)Calendar.getInstance().clone();
            calendar.setTime(date);
            if (addUnits.equals("hr") || addUnits.equals("hour")) {
                calendar.add(11, addAmount);
            } else if (addUnits.equals("min") || addUnits.equals("minute")) {
                calendar.add(12, addAmount);
            } else if (addUnits.equals("sec") || addUnits.equals("second")) {
                calendar.add(13, addAmount);
            } else if (addUnits.equals("day")) {
                calendar.add(6, addAmount);
            } else if (addUnits.equals("mo") || addUnits.equals("month")) {
                calendar.add(2, addAmount);
            } else if (addUnits.equals("yr") || addUnits.equals("year")) {
                calendar.add(1, addAmount);
            }
            String newDateString = new SimpleDateFormat(dateFormat).format(calendar.getTime());
            string = StringUtils.replace((String)string, (String)dateFormatString, (String)newDateString);
            dateFormatMatcher = dateFormatPattern.matcher(string);
        }
        return string;
    }

    public static String doDynamicDateFormatReplacement(String string, Metadata metadata) throws Exception {
        Pattern dateFormatPattern = Pattern.compile("\\[\\s*FORMAT\\s*\\(.{1,}?,.{1,}?,.{1,}?\\)\\s*\\]");
        Matcher dateFormatMatcher = dateFormatPattern.matcher(string);
        while (dateFormatMatcher.find()) {
            String dateFormatString = string.substring(dateFormatMatcher.start(), dateFormatMatcher.end());
            Matcher argMatcher = Pattern.compile("\\(.*\\)").matcher(dateFormatString);
            argMatcher.find();
            String argsString = dateFormatString.substring(argMatcher.start() + 1, argMatcher.end() - 1);
            argsString = PathUtils.doDynamicReplacement(argsString, metadata);
            String[] args = argsString.split(",");
            String curFormat = args[0].trim();
            String dateString = args[1].trim();
            String newFormat = args[2].trim();
            Date date = new SimpleDateFormat(curFormat).parse(dateString);
            String newDateString = new SimpleDateFormat(newFormat).format(date);
            string = StringUtils.replace((String)string, (String)dateFormatString, (String)newDateString);
            dateFormatMatcher = dateFormatPattern.matcher(string);
        }
        return string;
    }

    public static String doDynamicUtcToTaiDateReplacement(String string, Metadata metadata) throws Exception {
        Pattern utcToTaiPattern = Pattern.compile("\\[\\s*UTC_TO_TAI\\s*\\(.{1,}?\\)\\s*\\]");
        Matcher matcher = utcToTaiPattern.matcher(string);
        while (matcher.find()) {
            String utcToTaiString = string.substring(matcher.start(), matcher.end());
            Matcher argMatcher = Pattern.compile("\\(.*\\)").matcher(utcToTaiString);
            argMatcher.find();
            String utcDateString = utcToTaiString.substring(argMatcher.start() + 1, argMatcher.end() - 1).trim();
            utcDateString = PathUtils.doDynamicReplacement(utcDateString, metadata);
            string = StringUtils.replace((String)string, (String)utcToTaiString, (String)DateUtils.toString((Calendar)DateUtils.toTai((Calendar)DateUtils.toCalendar((String)utcDateString, (DateUtils.FormatType)DateUtils.FormatType.UTC_FORMAT))));
            matcher = utcToTaiPattern.matcher(string);
        }
        return string;
    }

    public static String doDynamicDateToSecsReplacement(String string, Metadata metadata) throws Exception {
        Pattern utcToTaiPattern = Pattern.compile("\\[\\s*DATE_TO_SECS\\s*\\(.{1,}?\\,.{1,}?,.{1,}?\\)\\s*\\]");
        Matcher matcher = utcToTaiPattern.matcher(string);
        while (matcher.find()) {
            String dateToSecsString = string.substring(matcher.start(), matcher.end());
            Matcher argMatcher = Pattern.compile("\\(.*\\)").matcher(dateToSecsString);
            argMatcher.find();
            String argsString = dateToSecsString.substring(argMatcher.start() + 1, argMatcher.end() - 1);
            argsString = PathUtils.doDynamicReplacement(argsString, metadata);
            String[] args = argsString.split(",");
            String dateString = args[0].trim();
            String dateType = args[1].trim();
            String epochString = args[2].trim();
            Calendar date = DateUtils.toCalendar((String)dateString, (DateUtils.FormatType)DateUtils.FormatType.valueOf((String)dateType));
            Calendar epoch = DateUtils.toLocalCustomFormatCalendar((String)epochString, (String)"yyyy-MM-dd");
            String seconds = DateUtils.toString((double)DateUtils.getTimeInSecs((Calendar)date, (Calendar)epoch));
            string = StringUtils.replace((String)string, (String)dateToSecsString, (String)seconds);
            matcher = utcToTaiPattern.matcher(string);
        }
        return string;
    }

    public static String doDynamicDateToMillisReplacement(String string, Metadata metadata) throws Exception {
        Pattern utcToTaiPattern = Pattern.compile("\\[\\s*DATE_TO_MILLIS\\s*\\(.{1,}?\\,.{1,}?,.{1,}?\\)\\s*\\]");
        Matcher matcher = utcToTaiPattern.matcher(string);
        while (matcher.find()) {
            String dateToMillisString = string.substring(matcher.start(), matcher.end());
            Matcher argMatcher = Pattern.compile("\\(.*\\)").matcher(dateToMillisString);
            argMatcher.find();
            String argsString = dateToMillisString.substring(argMatcher.start() + 1, argMatcher.end() - 1);
            argsString = PathUtils.doDynamicReplacement(argsString, metadata);
            String[] args = argsString.split(",");
            String dateString = args[0].trim();
            String dateType = args[1].trim();
            String epochString = args[2].trim();
            Calendar date = DateUtils.toCalendar((String)dateString, (DateUtils.FormatType)DateUtils.FormatType.valueOf((String)dateType));
            Calendar epoch = DateUtils.toLocalCustomFormatCalendar((String)epochString, (String)"yyyy-MM-dd");
            String milliseconds = DateUtils.getTimeInMillis((Calendar)date, (Calendar)epoch) + "";
            string = StringUtils.replace((String)string, (String)dateToMillisString, (String)milliseconds);
            matcher = utcToTaiPattern.matcher(string);
        }
        return string;
    }

    private static VarData readEnvVarName(String origPathStr, int startIdx) {
        StringBuffer varName = new StringBuffer();
        int idx = startIdx + 1;
        do {
            varName.append(origPathStr.charAt(idx));
        } while (origPathStr.charAt(++idx) != ']');
        VarData data = new PathUtils().new VarData();
        data.setFieldName(varName.toString());
        data.setEndIdx(idx);
        return data;
    }

    class VarData {
        private String fieldName = null;
        private int endIdx = -1;

        public int getEndIdx() {
            return this.endIdx;
        }

        public void setEndIdx(int endIdx) {
            this.endIdx = endIdx;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }
    }
}

