/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.cas.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.oodt.cas.metadata.Metadata;
import org.apache.oodt.commons.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SerializableMetadata
extends Metadata
implements Serializable {
    private static final long serialVersionUID = 6863087581652632499L;
    private String xmlEncoding;
    private boolean useCDATA;

    public SerializableMetadata() {
        this.xmlEncoding = "UTF-8";
        this.useCDATA = false;
    }

    public SerializableMetadata(String xmlEncoding, boolean useCDATA) throws InstantiationException {
        if (xmlEncoding == null) {
            throw new InstantiationException("xmlEncoding cannot be null");
        }
        this.xmlEncoding = xmlEncoding;
        this.useCDATA = useCDATA;
    }

    public SerializableMetadata(Metadata metadata) {
        this(metadata, "UTF-8", false);
    }

    public SerializableMetadata(InputStream inputStream) throws IOException {
        this(inputStream, "UTF-8", false);
    }

    public SerializableMetadata(InputStream inputStream, String xmlEncoding, boolean useCDATA) throws IOException {
        this.xmlEncoding = xmlEncoding;
        this.useCDATA = useCDATA;
        this.loadMetadataFromXmlStream(inputStream);
    }

    public SerializableMetadata(Metadata metadata, String xmlEncoding, boolean useCDATA) {
        this.replaceMetadata(metadata);
        this.xmlEncoding = xmlEncoding;
        this.useCDATA = useCDATA;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.xmlEncoding);
        out.writeBoolean(this.useCDATA);
        this.writeMetadataToXmlStream(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.xmlEncoding = (String)in.readObject();
        this.useCDATA = in.readBoolean();
        this.loadMetadataFromXmlStream(in);
    }

    public String getEncoding() {
        return this.xmlEncoding;
    }

    public boolean isUsingCDATA() {
        return this.useCDATA;
    }

    public void writeMetadataToXmlStream(OutputStream os) throws IOException {
        try {
            DOMSource source = new DOMSource(this.toXML());
            StreamResult result = new StreamResult(os);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", this.xmlEncoding);
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error generating metadata xml file!: " + e.getMessage());
        }
    }

    public Document toXML() throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().newDocument();
            Element root = document.createElementNS("http://oodt.jpl.nasa.gov/1.0/cas", "metadata");
            root.setPrefix("cas");
            document.appendChild(root);
            for (String key : this.getAllKeys()) {
                Element metadataElem = document.createElement("keyval");
                Element keyElem = document.createElement("key");
                if (this.useCDATA) {
                    keyElem.appendChild(document.createCDATASection(key));
                } else {
                    keyElem.appendChild(document.createTextNode(URLEncoder.encode(key, this.xmlEncoding)));
                }
                metadataElem.appendChild(keyElem);
                metadataElem.setAttribute("type", "vector");
                for (String value : this.getAllMetadata(key)) {
                    Element valElem = document.createElement("val");
                    if (value == null) {
                        throw new Exception("Attempt to write null value for property: [" + key + "]: val: [" + value + "]");
                    }
                    if (this.useCDATA) {
                        valElem.appendChild(document.createCDATASection(value));
                    } else {
                        valElem.appendChild(document.createTextNode(URLEncoder.encode(value, this.xmlEncoding)));
                    }
                    metadataElem.appendChild(valElem);
                }
                root.appendChild(metadataElem);
            }
            return document;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Failed to create XML DOM Document for SerializableMetadata : " + e.getMessage());
        }
    }

    public void loadMetadataFromXmlStream(InputStream in) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Element root = parser.parse(new InputSource(in)).getDocumentElement();
            NodeList keyValElems = root.getElementsByTagName("keyval");
            for (int i = 0; i < keyValElems.getLength(); ++i) {
                Element keyValElem = (Element)keyValElems.item(i);
                String elemName = XMLUtils.read((Element)keyValElem, (String)"key", (String)this.xmlEncoding);
                List elemValues = XMLUtils.readMany((Element)keyValElem, (String)"val", (String)this.xmlEncoding);
                this.addMetadata(elemName, elemValues);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to load SerializableMetadata from ObjectInputStream : " + e.getMessage());
        }
    }

    public Metadata getMetadata() {
        Metadata metadata = new Metadata();
        metadata.addMetadata(this.getHashtable());
        return metadata;
    }
}

